/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.ArrayList;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.test.ReplListener;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.MulticastInvalidationFuncTest")
public class MulticastInvalidationFuncTest
extends BaseDistFunctionalTest<Object, String> {
    public static final String KEY1 = "k1";

    public MulticastInvalidationFuncTest() {
        this.testRetVals = true;
        this.l1Threshold = 0;
    }

    public void testPut() {
        this.initAndTest();
        Cache nonOwner = this.getFirstNonOwner(KEY1);
        Cache owner = this.getOwners(KEY1)[0];
        ArrayList<ReplListener> listeners = new ArrayList<ReplListener>();
        nonOwner.put((Object)KEY1, (Object)"foo");
        AssertJUnit.assertNull((Object)nonOwner.getAdvancedCache().getDataContainer().get((Object)KEY1));
        Assert.assertEquals((String)((String)owner.getAdvancedCache().getDataContainer().get((Object)KEY1).getValue()), (String)"foo");
        if (owner.getAdvancedCache().getRpcManager().getTransport().isMulticastCapable()) {
            for (Cache c : this.getNonOwners(KEY1)) {
                ReplListener rl = new ReplListener(c);
                rl.expect((Class<? extends VisitableCommand>)InvalidateL1Command.class);
                listeners.add(rl);
                log.debugf("Added nonowner %s", c);
            }
        } else {
            ReplListener rl = new ReplListener(nonOwner);
            rl.expect((Class<? extends VisitableCommand>)InvalidateL1Command.class);
            listeners.add(rl);
        }
        owner.put((Object)KEY1, (Object)"bar");
        for (ReplListener rl : listeners) {
            rl.waitForRpc();
        }
        Assert.assertNull((Object)nonOwner.getAdvancedCache().getDataContainer().get((Object)KEY1));
    }
}

