/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.MagicKey;
import org.infinispan.distribution.TriangleOrderManager;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.distribution.TriangleDistributionInterceptor;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestException;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.MarshallingExceptionGenerator;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.infinispan.util.concurrent.CommandAckCollector;
import org.infinispan.util.concurrent.locks.LockManager;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="distribution.TriangleExceptionDuringMarshallingTest")
public class TriangleExceptionDuringMarshallingTest
extends MultipleCacheManagersTest {
    public static final int NUM_SEGMENTS = 3;

    @Override
    protected void createCacheManagers() throws Throwable {
        GlobalConfigurationBuilder globalBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        globalBuilder.serialization().marshaller((Marshaller)new JavaSerializationMarshaller());
        globalBuilder.serialization().allowList().addClasses(new Class[]{MagicKey.class, MarshallingExceptionGenerator.class});
        ConfigurationBuilder cacheBuilder = new ConfigurationBuilder();
        ControlledConsistentHashFactory.Default chf = new ControlledConsistentHashFactory.Default(new int[][]{{0, 1}, {1, 2}, {2, 0}});
        cacheBuilder.clustering().cacheMode(CacheMode.DIST_SYNC).hash().numSegments(3).consistentHashFactory((ConsistentHashFactory)chf);
        this.createCluster(globalBuilder, cacheBuilder, 3);
        AsyncInterceptorChain asyncInterceptorChain = TestingUtil.extractInterceptorChain(this.cache(0));
        AssertJUnit.assertTrue((boolean)asyncInterceptorChain.containsInterceptorType(TriangleDistributionInterceptor.class));
    }

    public void testExceptionDuringMarshallingOnOriginator() {
        MarshallingExceptionGenerator value = MarshallingExceptionGenerator.failOnSerialization(0);
        Cache originCache = this.cache(0);
        MagicKey primaryKey = new MagicKey("primary", this.cache(0));
        Exceptions.expectException(MarshallingException.class, () -> originCache.put((Object)primaryKey, value));
        this.assertCleanFailure(originCache, primaryKey);
        MagicKey nonOwnerKey = new MagicKey("non-owner", this.cache(1));
        Exceptions.expectException(MarshallingException.class, () -> originCache.put((Object)nonOwnerKey, value));
        this.assertCleanFailure(originCache, nonOwnerKey);
        MagicKey backupKey = new MagicKey("backup", this.cache(2));
        Exceptions.expectException(MarshallingException.class, () -> originCache.put((Object)backupKey, value));
        this.assertCleanFailure(originCache, backupKey);
    }

    public void testExceptionDuringMarshallingOnRemote() {
        MarshallingExceptionGenerator value = MarshallingExceptionGenerator.failOnSerialization(1);
        Cache originCache = this.cache(0);
        MagicKey primaryKey = new MagicKey("primary", this.cache(0));
        originCache.put((Object)primaryKey, (Object)value);
        originCache.remove((Object)primaryKey);
        MagicKey nonOwnerKey = new MagicKey("non-owner", this.cache(1));
        Exceptions.expectException(RemoteException.class, MarshallingException.class, () -> originCache.put((Object)nonOwnerKey, value));
        this.assertCleanFailure(originCache, nonOwnerKey);
        MagicKey backupKey = new MagicKey("backup", this.cache(2));
        Exceptions.expectException(RemoteException.class, MarshallingException.class, () -> originCache.put((Object)backupKey, value));
        this.assertCleanFailure(originCache, backupKey);
    }

    @Test(enabled=false, description="See ISPN-12770")
    public void testExceptionDuringUnmarshalling() {
        MarshallingExceptionGenerator value = MarshallingExceptionGenerator.failOnDeserialization(0);
        Cache originCache = this.cache(0);
        MagicKey primaryKey = new MagicKey("primary", this.cache(0));
        Exceptions.expectException(MarshallingException.class, () -> originCache.put((Object)primaryKey, value));
        this.assertCleanFailure(originCache, primaryKey);
        MagicKey nonOwnerKey = new MagicKey("non-owner", this.cache(1));
        Exceptions.expectException(MarshallingException.class, () -> originCache.put((Object)nonOwnerKey, value));
        this.assertCleanFailure(originCache, nonOwnerKey);
        MagicKey backupKey = new MagicKey("backup", this.cache(2));
        Exceptions.expectException(MarshallingException.class, () -> originCache.put((Object)backupKey, value));
        this.assertCleanFailure(originCache, backupKey);
    }

    private void assertCleanFailure(Cache<Object, Object> originCache, MagicKey key) {
        this.assertInvocationIsDone(Collections.singleton(key));
        this.assertCacheIsEmpty();
        originCache.put((Object)key, (Object)"good_value");
        originCache.remove((Object)key);
    }

    public void testExceptionDuringMarshallingOnOriginatorMultiKey() {
        MarshallingExceptionGenerator value = MarshallingExceptionGenerator.failOnSerialization(0);
        HashMap<MagicKey, MarshallingExceptionGenerator> values = new HashMap<MagicKey, MarshallingExceptionGenerator>();
        values.put(new MagicKey(this.cache(0)), value);
        values.put(new MagicKey(this.cache(1)), value);
        values.put(new MagicKey(this.cache(2)), value);
        for (Cache cache : this.caches()) {
            Exceptions.expectException(MarshallingException.class, () -> cache.putAll(values));
            this.assertInvocationIsDone(values.keySet());
            this.assertCacheIsEmpty();
        }
    }

    public void testExceptionDuringMarshallingOnRemoteMultiKey() {
        MarshallingExceptionGenerator value = MarshallingExceptionGenerator.failOnSerialization(1);
        HashMap<MagicKey, MarshallingExceptionGenerator> values = new HashMap<MagicKey, MarshallingExceptionGenerator>();
        values.put(new MagicKey(this.cache(0)), value);
        values.put(new MagicKey(this.cache(1)), value);
        values.put(new MagicKey(this.cache(2)), value);
        for (Cache cache : this.caches()) {
            Exceptions.expectException(RemoteException.class, MarshallingException.class, () -> cache.putAll(values));
            this.assertInvocationIsDone(values.keySet());
            for (Object key : values.keySet()) {
                cache.remove(key);
            }
        }
    }

    private void assertCacheIsEmpty() {
        for (Cache cache : this.caches()) {
            AssertJUnit.assertEquals((int)0, (int)cache.getAdvancedCache().getDataContainer().sizeIncludingExpired());
        }
    }

    private void assertInvocationIsDone(Collection<?> keys) {
        for (Cache cache : this.caches()) {
            CommandAckCollector ackCollector = TestingUtil.extractComponent(cache, CommandAckCollector.class);
            AssertJUnit.assertEquals(Collections.emptyList(), (Object)ackCollector.getPendingCommands());
            LockManager lm = TestingUtil.extractLockManager(cache);
            for (Object key : keys) {
                assert (!lm.isLocked(key));
            }
        }
    }

    @AfterMethod(alwaysRun=true)
    public void cleanup() {
        LocalizedCacheTopology cacheTopology = TestingUtil.extractCacheTopology(this.cache(0));
        int topologyId = cacheTopology.getTopologyId();
        for (Cache cache : this.caches()) {
            CommandAckCollector ackCollector = TestingUtil.extractComponent(cache, CommandAckCollector.class);
            for (Long pendingCommand : ackCollector.getPendingCommands()) {
                ackCollector.completeExceptionally(pendingCommand.longValue(), (Throwable)new TestException(), topologyId);
            }
            LockManager lockManager = TestingUtil.extractComponent(cache, LockManager.class);
            AssertJUnit.assertEquals((int)0, (int)lockManager.getNumberOfLocksHeld());
        }
        for (int segment = 0; segment < 3; ++segment) {
            DistributionInfo segmentDistribution = cacheTopology.getSegmentDistribution(segment);
            Address primary = segmentDistribution.primary();
            Cache primaryCache = this.manager(primary).getCache();
            long latestSequenceId = TestingUtil.extractComponent(primaryCache, TriangleOrderManager.class).latestSent(segment, topologyId);
            int i = 0;
            while ((long)i <= latestSequenceId) {
                for (Address backup : segmentDistribution.writeBackups()) {
                    Cache backupCache = this.manager(backup).getCache();
                    TestingUtil.extractComponent(backupCache, TriangleOrderManager.class).markDelivered(segment, (long)i, topologyId);
                }
                ++i;
            }
        }
    }
}

