/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.globalstate.impl.ScopedPersistentStateImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.PersistentUUID;
import org.infinispan.topology.PersistentUUIDManager;
import org.infinispan.topology.PersistentUUIDManagerImpl;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public abstract class BaseCHPersistenceTest {
    protected abstract ConsistentHashFactory<?> createConsistentHashFactory();

    protected abstract ConsistentHash createConsistentHash();

    public void testCHPersistence() {
        PersistentUUIDManagerImpl persistentUUIDManager = new PersistentUUIDManagerImpl();
        ConsistentHash ch = this.createConsistentHash();
        this.generateRandomPersistentUUIDs(ch.getMembers(), (PersistentUUIDManager)persistentUUIDManager);
        ScopedPersistentStateImpl state = new ScopedPersistentStateImpl("scope");
        ch.remapAddresses(persistentUUIDManager.addressToPersistentUUID()).toScopedState((ScopedPersistentState)state);
        ConsistentHashFactory<?> hashFactory = this.createConsistentHashFactory();
        ConsistentHash restoredCH = hashFactory.fromPersistentState((ScopedPersistentState)state).remapAddresses(persistentUUIDManager.persistentUUIDToAddress());
        AssertJUnit.assertEquals((Object)ch, (Object)restoredCH);
    }

    public void testCHPersistenceMissingMembers() {
        PersistentUUIDManagerImpl persistentUUIDManager = new PersistentUUIDManagerImpl();
        ConsistentHash ch = this.createConsistentHash();
        Map<Address, PersistentUUID> addressMap = this.generateRandomPersistentUUIDs(ch.getMembers(), (PersistentUUIDManager)persistentUUIDManager);
        ScopedPersistentStateImpl state = new ScopedPersistentStateImpl("scope");
        ch.remapAddresses(persistentUUIDManager.addressToPersistentUUID()).toScopedState((ScopedPersistentState)state);
        persistentUUIDManager.removePersistentAddressMapping(addressMap.keySet().iterator().next());
        ConsistentHashFactory<?> hashFactory = this.createConsistentHashFactory();
        ConsistentHash restoredCH = hashFactory.fromPersistentState((ScopedPersistentState)state).remapAddresses(persistentUUIDManager.persistentUUIDToAddress());
        AssertJUnit.assertNull((Object)restoredCH);
    }

    private Map<Address, PersistentUUID> generateRandomPersistentUUIDs(List<Address> members, PersistentUUIDManager persistentUUIDManager) {
        HashMap<Address, PersistentUUID> addressMap = new HashMap<Address, PersistentUUID>();
        for (Address member : members) {
            PersistentUUID uuid = PersistentUUID.randomUUID();
            persistentUUIDManager.addPersistentAddressMapping(member, uuid);
            addressMap.put(member, uuid);
        }
        return addressMap;
    }
}

