/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import org.infinispan.distribution.ch.impl.DefaultConsistentHash;
import org.infinispan.distribution.ch.impl.DefaultConsistentHashFactoryTest;
import org.infinispan.distribution.ch.impl.SyncConsistentHashFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="distribution.ch.SyncConsistentHashFactoryTest")
public class SyncConsistentHashFactoryTest
extends DefaultConsistentHashFactoryTest {
    protected SyncConsistentHashFactory createConsistentHashFactory() {
        return new SyncConsistentHashFactory();
    }

    @Override
    protected float maxOwned(int numSegments, int actualNumOwners, int numNodes, float expectedOwned) {
        if (expectedOwned == 0.0f) {
            return 0.0f;
        }
        float averageOwned = 1.0f * (float)numSegments * (float)actualNumOwners / (float)numNodes;
        float maxDiff = expectedOwned >= averageOwned ? 0.1f * expectedOwned : 0.1f * (expectedOwned + averageOwned);
        return expectedOwned + Math.max(maxDiff, 1.0f);
    }

    @Override
    protected float minOwned(int numSegments, int actualNumOwners, int numNodes, float expectedOwned) {
        if (expectedOwned == 0.0f) {
            return 0.0f;
        }
        float averageOwned = 1.0f * (float)numSegments * (float)actualNumOwners / (float)numNodes;
        float maxDiff = expectedOwned >= averageOwned ? 0.15f * expectedOwned : 0.05f * (expectedOwned + averageOwned);
        return expectedOwned - Math.max(maxDiff, 1.0f);
    }

    @Override
    protected float allowedExtraMoves(DefaultConsistentHash oldCH, DefaultConsistentHash newCH, int joinerSegments, int leaverSegments) {
        int oldSize = this.nodesWithLoad(oldCH.getMembers(), oldCH.getCapacityFactors());
        int newSize = this.nodesWithLoad(newCH.getMembers(), newCH.getCapacityFactors());
        int maxSize = Math.max(oldSize, newSize);
        return Math.max((float)maxSize, 0.15f * (float)newCH.getNumOwners() * (float)newCH.getNumSegments());
    }

    public void testFudgeExpectedSegments() {
        float averageSegments = 10.0f;
        AssertJUnit.assertEquals((int)0, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)0.1f, (float)averageSegments, (int)0));
        AssertJUnit.assertEquals((int)0, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)0.1f, (float)averageSegments, (int)1));
        AssertJUnit.assertEquals((int)0, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)0.1f, (float)averageSegments, (int)2));
        AssertJUnit.assertEquals((int)0, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)0.1f, (float)averageSegments, (int)3));
        AssertJUnit.assertEquals((int)1, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)0.1f, (float)averageSegments, (int)4));
        AssertJUnit.assertEquals((int)2, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)0.1f, (float)averageSegments, (int)5));
        AssertJUnit.assertEquals((int)0, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)0.9f, (float)averageSegments, (int)0));
        AssertJUnit.assertEquals((int)0, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)0.9f, (float)averageSegments, (int)1));
        AssertJUnit.assertEquals((int)0, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)0.9f, (float)averageSegments, (int)2));
        AssertJUnit.assertEquals((int)1, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)0.9f, (float)averageSegments, (int)3));
        AssertJUnit.assertEquals((int)2, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)0.9f, (float)averageSegments, (int)4));
        AssertJUnit.assertEquals((int)0, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)1.4f, (float)averageSegments, (int)0));
        AssertJUnit.assertEquals((int)0, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)1.4f, (float)averageSegments, (int)1));
        AssertJUnit.assertEquals((int)0, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)1.4f, (float)averageSegments, (int)2));
        AssertJUnit.assertEquals((int)1, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)1.4f, (float)averageSegments, (int)3));
        AssertJUnit.assertEquals((int)2, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)1.4f, (float)averageSegments, (int)4));
        AssertJUnit.assertEquals((int)0, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)1.6f, (float)averageSegments, (int)0));
        AssertJUnit.assertEquals((int)0, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)1.6f, (float)averageSegments, (int)1));
        AssertJUnit.assertEquals((int)1, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)1.6f, (float)averageSegments, (int)2));
        AssertJUnit.assertEquals((int)2, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)1.6f, (float)averageSegments, (int)3));
        AssertJUnit.assertEquals((int)3, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)1.6f, (float)averageSegments, (int)4));
        AssertJUnit.assertEquals((int)1, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)4.4f, (float)averageSegments, (int)0));
        AssertJUnit.assertEquals((int)2, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)4.4f, (float)averageSegments, (int)1));
        AssertJUnit.assertEquals((int)3, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)4.4f, (float)averageSegments, (int)2));
        AssertJUnit.assertEquals((int)4, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)4.4f, (float)averageSegments, (int)3));
        AssertJUnit.assertEquals((int)5, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)4.4f, (float)averageSegments, (int)4));
        AssertJUnit.assertEquals((int)2, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)4.6f, (float)averageSegments, (int)0));
        AssertJUnit.assertEquals((int)3, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)4.6f, (float)averageSegments, (int)1));
        AssertJUnit.assertEquals((int)4, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)4.6f, (float)averageSegments, (int)2));
        AssertJUnit.assertEquals((int)5, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)4.6f, (float)averageSegments, (int)3));
        AssertJUnit.assertEquals((int)6, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)4.6f, (float)averageSegments, (int)4));
        AssertJUnit.assertEquals((int)7, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)10.0f, (float)averageSegments, (int)0));
        AssertJUnit.assertEquals((int)8, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)10.0f, (float)averageSegments, (int)1));
        AssertJUnit.assertEquals((int)9, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)10.0f, (float)averageSegments, (int)2));
        AssertJUnit.assertEquals((int)10, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)10.0f, (float)averageSegments, (int)3));
        AssertJUnit.assertEquals((int)11, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)10.0f, (float)averageSegments, (int)4));
        AssertJUnit.assertEquals((int)97, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)100.0f, (float)averageSegments, (int)0));
        AssertJUnit.assertEquals((int)98, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)100.0f, (float)averageSegments, (int)1));
        AssertJUnit.assertEquals((int)99, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)100.0f, (float)averageSegments, (int)2));
        AssertJUnit.assertEquals((int)100, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)100.0f, (float)averageSegments, (int)3));
        AssertJUnit.assertEquals((int)101, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)100.0f, (float)averageSegments, (int)4));
        AssertJUnit.assertEquals((int)997, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)1000.0f, (float)averageSegments, (int)0));
        AssertJUnit.assertEquals((int)998, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)1000.0f, (float)averageSegments, (int)1));
        AssertJUnit.assertEquals((int)999, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)1000.0f, (float)averageSegments, (int)2));
        AssertJUnit.assertEquals((int)1000, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)1000.0f, (float)averageSegments, (int)3));
        AssertJUnit.assertEquals((int)1001, (int)SyncConsistentHashFactory.Builder.fudgeExpectedSegments((float)1000.0f, (float)averageSegments, (int)4));
    }
}

