/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.rehash.RehashTestBase;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.ConcurrentJoinTest", description="See ISPN-1123")
public class ConcurrentJoinTest
extends RehashTestBase {
    List<EmbeddedCacheManager> joinerManagers;
    List<Cache<Object, String>> joiners;
    static final int NUM_JOINERS = 4;

    @Override
    void performRehashEvent(boolean offline) throws Exception {
        int i;
        this.joinerManagers = new CopyOnWriteArrayList<EmbeddedCacheManager>();
        this.joiners = new CopyOnWriteArrayList<Cache>(new Cache[4]);
        for (int i2 = 0; i2 < 4; ++i2) {
            EmbeddedCacheManager joinerManager = this.addClusterEnabledCacheManager(TestDataSCI.INSTANCE, new ConfigurationBuilder());
            joinerManager.defineConfiguration(this.cacheName, this.configuration.build());
            this.joinerManagers.add(joinerManager);
            this.joiners.set(i2, null);
        }
        Future[] threads = new Future[4];
        for (i = 0; i < 4; ++i) {
            int ii = i;
            threads[i] = this.fork(() -> {
                EmbeddedCacheManager joinerManager = this.joinerManagers.get(ii);
                Cache joiner = joinerManager.getCache(this.cacheName);
                this.joiners.set(ii, (Cache<Object, String>)joiner);
            });
        }
        for (i = 0; i < 4; ++i) {
            threads[i].get(30L, TimeUnit.SECONDS);
        }
    }

    @Override
    void waitForRehashCompletion() {
        ArrayList allCacheManagers = new ArrayList(this.cacheManagers);
        TestingUtil.blockUntilViewsReceived(60000, false, allCacheManagers);
        this.waitForClusterToForm(this.cacheName);
        for (int i = 0; i < 4; ++i) {
            this.caches.add(this.joiners.get(i));
        }
    }
}

