/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.commons.TimeoutException;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"stress"}, testName="distribution.rehash.ConsistencyStressTest", timeOut=900000L)
public class ConsistencyStressTest
extends MultipleCacheManagersTest {
    private static final int NUM_NODES = 10;
    private static final int WORKERS_PER_NODE = 2;
    private static final int NUM_ITERATIONS = 5000;
    private static final boolean IGNORE_TX_FAILURES = true;
    private static final Log log = LogFactory.getLog(ConsistencyStressTest.class);

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.locking().isolationLevel(IsolationLevel.READ_COMMITTED).lockAcquisitionTimeout(60000L).useLockStriping(false).clustering().cacheMode(CacheMode.DIST_SYNC).remoteTimeout(30000L).l1().disable().transaction().lockingMode(LockingMode.PESSIMISTIC).transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        GlobalConfigurationBuilder gc = GlobalConfigurationBuilder.defaultClusteredBuilder();
        gc.transport().distributedSyncTimeout(60000L);
        LinkedList<EmbeddedCacheManager> cacheManagers = new LinkedList<EmbeddedCacheManager>();
        for (int i = 0; i < 10; ++i) {
            cacheManagers.add(TestCacheManagerFactory.createClusteredCacheManager(gc, c));
        }
        this.registerCacheManager((CacheContainer[])cacheManagers.toArray(new EmbeddedCacheManager[10]));
    }

    /*
     * WARNING - void declaration
     */
    public void testConsistency() throws Throwable {
        void var4_9;
        HashSet<Future<Void>> futures = new HashSet<Future<Void>>(20);
        HashSet<String> keysToIgnore = new HashSet<String>();
        for (int i = 0; i < 10; ++i) {
            Cache cache = this.cache(i);
            for (int j = 0; j < 2; ++j) {
                Future<Void> f = this.fork(new Stressor(cache, i, j, keysToIgnore));
                futures.add(f);
                TestingUtil.sleepRandom(500);
            }
        }
        log.info((Object)"Waiting for stressors to finish");
        for (Future future : futures) {
            future.get();
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager)this.cacheManagers.get(0));
        HashMap cacheMap = new HashMap();
        boolean bl = true;
        while (var4_9 < 10) {
            Cache c = this.cache((int)var4_9);
            cacheMap.put(this.address(c), c);
            ++var4_9;
        }
        Thread.sleep(25000L);
        TestingUtil.blockUntilViewsReceived(60000, false, cacheMap.values());
        TestingUtil.waitForNoRebalance(cacheMap.values());
        LocalizedCacheTopology localizedCacheTopology = this.cache(1).getAdvancedCache().getDistributionManager().getCacheTopology();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 5000; ++k) {
                    String key = ConsistencyStressTest.keyFor(i, j, k);
                    if (keysToIgnore.contains(key)) {
                        log.infof("Skipping test on failing key %s", (Object)key);
                        continue;
                    }
                    Collection owners = localizedCacheTopology.getWriteOwners((Object)key);
                    for (Map.Entry e : cacheMap.entrySet()) {
                        try {
                            if (!owners.contains(e.getKey())) continue;
                            DistributionTestHelper.assertIsInContainerImmortal((Cache)e.getValue(), key);
                        }
                        catch (Throwable th) {
                            log.fatalf("Key %s (segment %s) should be on owners %s according to %s", new Object[]{key, localizedCacheTopology.getSegment((Object)key), owners, localizedCacheTopology});
                            throw th;
                        }
                    }
                }
            }
        }
    }

    private static String keyFor(int nodeId, int workerId, int iterationId) {
        return String.format("__%s_%s_%s__", nodeId, workerId, iterationId);
    }

    private static class Stressor
    implements Callable<Void> {
        private final Cache<String, String> cache;
        private final TransactionManager tm;
        private final int cacheId;
        private final int workerId;
        private final Set<String> keysToIgnore;

        private Stressor(Cache<String, String> cache, int cacheId, int workerId, Set<String> keysToIgnore) {
            this.cache = cache;
            this.tm = TestingUtil.getTransactionManager(cache);
            this.cacheId = cacheId;
            this.workerId = workerId;
            this.keysToIgnore = keysToIgnore;
        }

        @Override
        public Void call() throws TimeoutException {
            for (int iterationId = 0; iterationId < 5000; ++iterationId) {
                if (iterationId % 500 == 0) {
                    log.infof("  >> Stressor %s Worker %s Iteration %s", (Object)this.cacheId, (Object)this.workerId, (Object)iterationId);
                }
                boolean txError = false;
                Throwable exception = null;
                String key = ConsistencyStressTest.keyFor(this.cacheId, this.workerId, iterationId);
                try {
                    this.tm.begin();
                    this.cache.getAdvancedCache().withFlags(Flag.SKIP_REMOTE_LOOKUP).put((Object)key, (Object)"value");
                    this.tm.commit();
                }
                catch (HeuristicMixedException | HeuristicRollbackException | NotSupportedException | RollbackException | SystemException | TimeoutException e) {
                    txError = true;
                    exception = e;
                }
                if (!txError) continue;
                try {
                    this.tm.rollback();
                }
                catch (Exception exc) {
                    log.error((Object)"  >> Rollback failed");
                }
                this.keysToIgnore.add(key);
                log.errorf("  >> Saw a %s when trying to process key %s", (Object)exception.getClass().getSimpleName(), (Object)key);
            }
            return null;
        }
    }
}

