/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.distribution.MagicKey;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.DefaultConsistentHash;
import org.infinispan.distribution.ch.impl.DefaultConsistentHashFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"unstable"}, testName="distribution.rehash.WorkDuringJoinTest", description="original group: functional")
public class WorkDuringJoinTest
extends BaseDistFunctionalTest<Object, String> {
    EmbeddedCacheManager joinerManager;
    Cache<Object, String> joiner;

    public WorkDuringJoinTest() {
        this.INIT_CLUSTER_SIZE = 2;
        this.performRehashing = true;
    }

    private List<MagicKey> init() {
        ArrayList<MagicKey> keys = new ArrayList<MagicKey>(Arrays.asList(new MagicKey("k1", this.c1), new MagicKey("k2", this.c2), new MagicKey("k3", this.c1), new MagicKey("k4", this.c2)));
        int i = 0;
        for (Cache c : this.caches) {
            c.put(keys.get(i++), (Object)("v" + i));
        }
        log.infof("Initialized with keys %s", keys);
        return keys;
    }

    Address startNewMember() {
        this.joinerManager = this.addClusterEnabledCacheManager();
        this.joinerManager.defineConfiguration(this.cacheName, this.configuration.build());
        this.joiner = this.joinerManager.getCache(this.cacheName);
        return this.manager(this.joiner).getAddress();
    }

    public void testJoinAndGet() {
        List<MagicKey> keys = this.init();
        KeyPartitioner keyPartitioner = TestingUtil.extractComponent(this.c1, KeyPartitioner.class);
        ConsistentHash chOld = this.getCacheTopology(this.c1).getWriteConsistentHash();
        Address joinerAddress = this.startNewMember();
        ArrayList<Address> newMembers = new ArrayList<Address>(chOld.getMembers());
        newMembers.add(joinerAddress);
        DefaultConsistentHashFactory chf = new DefaultConsistentHashFactory();
        DefaultConsistentHash chNew = chf.rebalance(chf.updateMembers((DefaultConsistentHash)chOld, newMembers, null));
        MagicKey keyToTest = null;
        for (MagicKey k : keys) {
            int segment = keyPartitioner.getSegment((Object)k);
            if (!chNew.isSegmentLocalToNode(joinerAddress, segment)) continue;
            keyToTest = k;
            break;
        }
        if (keyToTest == null) {
            throw new NullPointerException("Couldn't find a key mapped to J!");
        }
        assert (this.joiner.get(keyToTest) != null);
    }
}

