/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.topologyaware;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.DistSyncFuncTest;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.topologyaware.TopologyAwareChFunctionalTest")
public class TopologyAwareChFunctionalTest
extends DistSyncFuncTest {
    @Override
    protected EmbeddedCacheManager addClusterEnabledCacheManager(TransportFlags flags) {
        String rack;
        int index = this.cacheManagers.size();
        String machine = switch (index) {
            case 0 -> {
                rack = "r0";
                yield "m0";
            }
            case 1 -> {
                rack = "r0";
                yield "m1";
            }
            case 2 -> {
                rack = "r1";
                yield "m0";
            }
            case 3 -> {
                rack = "r2";
                yield "m0";
            }
            default -> throw new RuntimeException("Bad!");
        };
        GlobalConfigurationBuilder gc = GlobalConfigurationBuilder.defaultClusteredBuilder();
        gc.transport().rackId(rack).machineId(machine);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager(gc, new ConfigurationBuilder());
        this.cacheManagers.add(cm);
        return cm;
    }

    public void testHashesInitiated() {
        ConsistentHash hash = this.advancedCache(0, this.cacheName).getDistributionManager().getWriteConsistentHash();
        this.containsAllHashes(hash);
        this.containsAllHashes(this.advancedCache(1, this.cacheName).getDistributionManager().getWriteConsistentHash());
        this.containsAllHashes(this.advancedCache(2, this.cacheName).getDistributionManager().getWriteConsistentHash());
        this.containsAllHashes(this.advancedCache(3, this.cacheName).getDistributionManager().getWriteConsistentHash());
    }

    private void containsAllHashes(ConsistentHash ch) {
        assert (ch.getMembers().contains(this.address(0)));
        assert (ch.getMembers().contains(this.address(1)));
        assert (ch.getMembers().contains(this.address(2)));
        assert (ch.getMembers().contains(this.address(3)));
    }
}

