/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.topologyaware;

import java.util.Collection;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.impl.DefaultConsistentHash;
import org.infinispan.distribution.ch.impl.OwnershipStatistics;
import org.infinispan.distribution.topologyaware.TopologyInfo;
import org.infinispan.remoting.transport.Address;

class TopologyAwareOwnershipStatistics {
    TopologyInfo topologyInfo;
    OwnershipStatistics stats;
    private final int numSegments;
    private final int numOwners;

    public TopologyAwareOwnershipStatistics(DefaultConsistentHash ch) {
        this.numSegments = ch.getNumSegments();
        this.numOwners = ch.getNumOwners();
        this.topologyInfo = new TopologyInfo(this.numSegments, this.numOwners, (Collection)ch.getMembers(), ch.getCapacityFactors());
        this.stats = new OwnershipStatistics((ConsistentHash)ch, ch.getMembers());
    }

    public TopologyAwareOwnershipStatistics(TopologyInfo topologyInfo, OwnershipStatistics stats, int numSegments, int numOwners) {
        this.topologyInfo = topologyInfo;
        this.stats = stats;
        this.numSegments = numSegments;
        this.numOwners = numOwners;
    }

    public int getSiteOwned(String site) {
        int count = 0;
        for (Address node : this.topologyInfo.getSiteNodes(site)) {
            count += this.stats.getOwned(node);
        }
        return count;
    }

    public int getSitePrimaryOwned(String site) {
        int count = 0;
        for (Address node : this.topologyInfo.getSiteNodes(site)) {
            count += this.stats.getPrimaryOwned(node);
        }
        return count;
    }

    public int getRackOwned(String site, String rack) {
        int count = 0;
        for (Address node : this.topologyInfo.getRackNodes(site, rack)) {
            count += this.stats.getOwned(node);
        }
        return count;
    }

    public int getRackPrimaryOwned(String site, String rack) {
        int count = 0;
        for (Address node : this.topologyInfo.getRackNodes(site, rack)) {
            count += this.stats.getPrimaryOwned(node);
        }
        return count;
    }

    public int getMachineOwned(String site, String rack, String machine) {
        int count = 0;
        for (Address node : this.topologyInfo.getMachineNodes(site, rack, machine)) {
            count += this.stats.getOwned(node);
        }
        return count;
    }

    public int getMachinePrimaryOwned(String site, String rack, String machine) {
        int count = 0;
        for (Address node : this.topologyInfo.getMachineNodes(site, rack, machine)) {
            count += this.stats.getPrimaryOwned(node);
        }
        return count;
    }

    public int getOwned(Address node) {
        return this.stats.getOwned(node);
    }

    public int getPrimaryOwned(Address node) {
        return this.stats.getPrimaryOwned(node);
    }

    public float computeExpectedPrimarySegments(Address node) {
        return this.topologyInfo.getExpectedPrimarySegments(node);
    }

    public float computeExpectedOwnedSegments(Address node) {
        return this.topologyInfo.getExpectedOwnedSegments(node);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TopologyAwareOwnershipStatistics{\n");
        sb.append(String.format("cluster: %d(%dp)\n", this.stats.sumOwned(), this.stats.sumPrimaryOwned()));
        for (String site : this.topologyInfo.getAllSites()) {
            sb.append(String.format("  %s: %d(%dp)\n", site, this.getSiteOwned(site), this.getSitePrimaryOwned(site)));
            for (String rack : this.topologyInfo.getSiteRacks(site)) {
                sb.append(String.format("    %s: %d(%dp)\n", rack, this.getRackOwned(site, rack), this.getRackPrimaryOwned(site, rack)));
                for (String machine : this.topologyInfo.getRackMachines(site, rack)) {
                    sb.append(String.format("      %s: %d(%dp)\n", machine, this.getMachineOwned(site, rack, machine), this.getMachinePrimaryOwned(site, rack, machine)));
                    for (Address node : this.topologyInfo.getMachineNodes(site, rack, machine)) {
                        sb.append(String.format("        %s: %d(%dp) %.1f(%.1fp)\n", node, this.getOwned(node), this.stats.getPrimaryOwned(node), Float.valueOf(this.topologyInfo.getExpectedOwnedSegments(node)), Float.valueOf(this.topologyInfo.getExpectedPrimarySegments(node))));
                    }
                }
            }
        }
        sb.append('}');
        return sb.toString();
    }
}

