/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.expiration.impl.ExpirationFileStoreListenerFunctionalTest;
import org.infinispan.expiration.impl.ExpirationStoreFunctionalTest;
import org.infinispan.expiration.impl.ExpirationStoreListenerFunctionalTest;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="expiration.impl.ExpirationFileStoreDistListenerFunctionalTest")
public class ExpirationFileStoreDistListenerFunctionalTest
extends ExpirationStoreListenerFunctionalTest {
    private static final String PERSISTENT_LOCATION = CommonsTestingUtil.tmpDirectory(ExpirationFileStoreDistListenerFunctionalTest.class);
    private static final String EXTRA_MANAGER_LOCATION = CommonsTestingUtil.tmpDirectory((String[])new String[]{String.valueOf(ExpirationFileStoreDistListenerFunctionalTest.class) + "2"});
    private EmbeddedCacheManager extraManager;
    private Cache<Object, Object> extraCache;
    private ExpirationFileStoreListenerFunctionalTest.FileStoreToUse fileStoreToUse;

    ExpirationStoreFunctionalTest fileStoreToUse(ExpirationFileStoreListenerFunctionalTest.FileStoreToUse fileStoreToUse) {
        this.fileStoreToUse = fileStoreToUse;
        return this;
    }

    @Override
    @Factory
    public Object[] factory() {
        return new Object[]{new ExpirationFileStoreDistListenerFunctionalTest().fileStoreToUse(ExpirationFileStoreListenerFunctionalTest.FileStoreToUse.SINGLE).cacheMode(CacheMode.DIST_SYNC), new ExpirationFileStoreDistListenerFunctionalTest().fileStoreToUse(ExpirationFileStoreListenerFunctionalTest.FileStoreToUse.SOFT_INDEX).cacheMode(CacheMode.DIST_SYNC)};
    }

    @Override
    protected String parameters() {
        return "[ " + String.valueOf((Object)this.fileStoreToUse) + "]";
    }

    @Override
    protected void configure(ConfigurationBuilder config) {
        config.expiration().wakeUpInterval(Long.MAX_VALUE).clustering().cacheMode(this.cacheMode);
        switch (this.fileStoreToUse) {
            case SINGLE: {
                config.persistence().addSingleFileStore();
                break;
            }
            case SOFT_INDEX: {
                config.persistence().addSoftIndexFileStore();
            }
        }
    }

    @Override
    protected void removeFromContainer(String key) {
        super.removeFromContainer(key);
        this.extraCache.getAdvancedCache().getDataContainer().remove((Object)key);
    }

    @Override
    protected void processExpiration() {
        super.processExpiration();
        TestingUtil.extractComponent(this.extraCache, InternalExpirationManager.class).processExpiration();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void clearContent() {
        super.clearContent();
        TestingUtil.clearContent(this.extraManager);
    }

    @Override
    protected void teardown() {
        super.teardown();
        TestingUtil.killCacheManagers(this.extraManager);
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroyAfterClass() {
        super.destroyAfterClass();
        Util.recursiveFileRemove((String)PERSISTENT_LOCATION);
        Util.recursiveFileRemove((String)EXTRA_MANAGER_LOCATION);
    }

    @Override
    protected EmbeddedCacheManager createCacheManager(ConfigurationBuilder builder) {
        GlobalConfigurationBuilder globalBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        this.configure(globalBuilder);
        globalBuilder.globalState().enable().persistentLocation(EXTRA_MANAGER_LOCATION);
        this.extraManager = TestCacheManagerFactory.createClusteredCacheManager(false, globalBuilder, builder, new TransportFlags());
        TestingUtil.replaceComponent((CacheContainer)this.extraManager, TimeService.class, this.timeService, true);
        this.extraCache = this.extraManager.getCache();
        globalBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        this.configure(globalBuilder);
        globalBuilder.globalState().enable().persistentLocation(PERSISTENT_LOCATION);
        EmbeddedCacheManager returned = TestCacheManagerFactory.createClusteredCacheManager(false, globalBuilder, builder, new TransportFlags());
        TestingUtil.replaceComponent((CacheContainer)returned, TimeService.class, this.timeService, true);
        Cache checkCache = returned.getCache();
        TestingUtil.blockUntilViewReceived(checkCache, 2, TimeUnit.SECONDS.toMillis(10L));
        return returned;
    }

    @Override
    protected Object keyToUseWithExpiration() {
        return new MagicKey(this.cache);
    }
}

