/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.expiration.impl.ExpirationStoreFunctionalTest;
import org.infinispan.expiration.impl.ExpirationStoreListenerFunctionalTest;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="expiration.impl.ExpirationFileStoreListenerFunctionalTest")
public class ExpirationFileStoreListenerFunctionalTest
extends ExpirationStoreListenerFunctionalTest {
    private final String location = CommonsTestingUtil.tmpDirectory(this.getClass());
    private FileStoreToUse fileStoreToUse;

    ExpirationStoreFunctionalTest fileStoreToUse(FileStoreToUse fileStoreToUse) {
        this.fileStoreToUse = fileStoreToUse;
        return this;
    }

    @Override
    @Factory
    public Object[] factory() {
        return new Object[]{new ExpirationFileStoreListenerFunctionalTest().fileStoreToUse(FileStoreToUse.SINGLE).cacheMode(CacheMode.LOCAL), new ExpirationFileStoreListenerFunctionalTest().fileStoreToUse(FileStoreToUse.SOFT_INDEX).cacheMode(CacheMode.LOCAL)};
    }

    @Override
    protected String parameters() {
        return "[ " + String.valueOf((Object)this.fileStoreToUse) + "]";
    }

    @Override
    protected void configure(GlobalConfigurationBuilder globalBuilder) {
        super.configure(globalBuilder);
        globalBuilder.globalState().enable().persistentLocation(this.location);
    }

    @Override
    protected void configure(ConfigurationBuilder config) {
        config.expiration().wakeUpInterval(Long.MAX_VALUE);
        switch (this.fileStoreToUse.ordinal()) {
            case 0: {
                config.persistence().addSingleFileStore().location(this.location);
                break;
            }
            case 1: {
                config.persistence().addSoftIndexFileStore().dataLocation(this.location);
            }
        }
    }

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        Util.recursiveFileRemove((String)CommonsTestingUtil.tmpDirectory(this.getClass()));
    }

    static enum FileStoreToUse {
        SINGLE,
        SOFT_INDEX;

    }
}

