/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiry;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="expiry.ReplicatedExpiryTest")
public class ReplicatedExpiryTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = ReplicatedExpiryTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
        this.createClusteredCaches(2, "cache", builder);
    }

    public void testLifespanExpiryReplicates() {
        Cache c1 = this.cache(0, "cache");
        Cache c2 = this.cache(1, "cache");
        long lifespan = 3000L;
        c1.put((Object)"k", (Object)"v", lifespan, TimeUnit.MILLISECONDS);
        InternalCacheEntry ice = c2.getAdvancedCache().getDataContainer().get((Object)"k");
        assert (ice instanceof MortalCacheEntry);
        assert (ice.getLifespan() == lifespan);
        assert (ice.getMaxIdle() == -1L);
    }

    public void testIdleExpiryReplicates() {
        Cache c1 = this.cache(0, "cache");
        Cache c2 = this.cache(1, "cache");
        long idle = 3000L;
        c1.put((Object)"k", (Object)"v", -1L, TimeUnit.MILLISECONDS, idle, TimeUnit.MILLISECONDS);
        InternalCacheEntry ice = c2.getAdvancedCache().getDataContainer().get((Object)"k");
        assert (ice instanceof TransientCacheEntry);
        assert (ice.getMaxIdle() == idle);
        assert (ice.getLifespan() == -1L);
    }

    public void testBothExpiryReplicates() {
        Cache c1 = this.cache(0, "cache");
        Cache c2 = this.cache(1, "cache");
        long lifespan = 10000L;
        long idle = 3000L;
        c1.put((Object)"k", (Object)"v", lifespan, TimeUnit.MILLISECONDS, idle, TimeUnit.MILLISECONDS);
        InternalCacheEntry ice = c2.getAdvancedCache().getDataContainer().get((Object)"k");
        assert (ice instanceof TransientMortalCacheEntry);
        assert (ice.getLifespan() == lifespan) : "Expected " + lifespan + " but was " + ice.getLifespan();
        assert (ice.getMaxIdle() == idle) : "Expected " + idle + " but was " + ice.getMaxIdle();
    }
}

