/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.infinispan.functional.AbstractFunctionalTest;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.functional.decorators.FunctionalConcurrentMap;
import org.infinispan.manager.EmbeddedCacheManager;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="functional.FunctionalConcurrentMapTest")
public class FunctionalConcurrentMapTest
extends AbstractFunctionalTest {
    ConcurrentMap<Integer, String> simple1;
    ConcurrentMap<Integer, String> simple2;
    ConcurrentMap<Integer, String> local1;
    ConcurrentMap<Integer, String> local2;
    ConcurrentMap<Object, String> dist1;
    ConcurrentMap<Object, String> dist2;
    ConcurrentMap<Object, String> repl1;
    ConcurrentMap<Object, String> repl2;

    @Override
    @BeforeClass
    public void createBeforeClass() throws Throwable {
        super.createBeforeClass();
        this.simple1 = FunctionalConcurrentMap.create(((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache("simple").getAdvancedCache());
        this.simple2 = FunctionalConcurrentMap.create(((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache("simple").getAdvancedCache());
        this.local1 = FunctionalConcurrentMap.create(((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache().getAdvancedCache());
        this.local2 = FunctionalConcurrentMap.create(((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache().getAdvancedCache());
        this.dist1 = FunctionalConcurrentMap.create(((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache("dist").getAdvancedCache());
        this.dist2 = FunctionalConcurrentMap.create(((EmbeddedCacheManager)this.cacheManagers.get(1)).getCache("dist").getAdvancedCache());
        this.repl1 = FunctionalConcurrentMap.create(((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache("repl").getAdvancedCache());
        this.repl2 = FunctionalConcurrentMap.create(((EmbeddedCacheManager)this.cacheManagers.get(1)).getCache("repl").getAdvancedCache());
    }

    public void testSimpleEmptyGetThenPut() {
        this.doEmptyGetThenPut(FunctionalTestUtils.supplyIntKey(), this.simple1, this.simple2);
    }

    public void testLocalEmptyGetThenPut() {
        this.doEmptyGetThenPut(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testReplEmptyGetThenPutOnNonOwner() {
        this.doEmptyGetThenPut(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplEmptyGetThenPutOnOwner() {
        this.doEmptyGetThenPut(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistEmptyGetThenPutOnNonOwner() {
        this.doEmptyGetThenPut(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistEmptyGetThenPutOnOwner() {
        this.doEmptyGetThenPut(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doEmptyGetThenPut(Supplier<K> keySupplier, ConcurrentMap<K, String> readMap, ConcurrentMap<K, String> writeMap) {
        K key = keySupplier.get();
        AssertJUnit.assertEquals(null, (String)((String)readMap.get(key)));
        AssertJUnit.assertEquals(null, (String)writeMap.put(key, "one"));
        AssertJUnit.assertEquals((String)"one", (String)((String)readMap.get(key)));
    }

    public void testLocalPutGet() {
        this.doPutGet(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testSimplePutGet() {
        this.doPutGet(FunctionalTestUtils.supplyIntKey(), this.simple1, this.simple2);
    }

    public void testReplPutGetOnNonOwner() {
        this.doPutGet(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testReplPutGetOnOwner() {
        this.doPutGet(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testDistPutGetOnNonOwner() {
        this.doPutGet(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistPutGetOnOwner() {
        this.doPutGet(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doPutGet(Supplier<K> keySupplier, ConcurrentMap<K, String> readMap, ConcurrentMap<K, String> writeMap) {
        K key = keySupplier.get();
        AssertJUnit.assertEquals(null, (String)writeMap.put(key, "one"));
        AssertJUnit.assertEquals((String)"one", (String)((String)readMap.get(key)));
    }

    public void testLocalPutUpdate() {
        this.doPutUpdate(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testSimplePutUpdate() {
        this.doPutUpdate(FunctionalTestUtils.supplyIntKey(), this.simple1, this.simple2);
    }

    public void testReplPutUpdateOnNonOwner() {
        this.doPutUpdate(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplPutUpdateOnOwner() {
        this.doPutUpdate(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testDistPutUpdateOnNonOwner() {
        this.doPutUpdate(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistPutUpdateOnOwner() {
        this.doPutUpdate(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doPutUpdate(Supplier<K> keySupplier, ConcurrentMap<K, String> readMap, ConcurrentMap<K, String> writeMap) {
        K key = keySupplier.get();
        AssertJUnit.assertEquals(null, (String)writeMap.put(key, "one"));
        AssertJUnit.assertEquals((String)"one", (String)writeMap.put(key, "uno"));
        AssertJUnit.assertEquals((String)"uno", (String)((String)readMap.get(key)));
    }

    public void testLocalGetAndRemove() {
        this.doGetAndRemove(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testSimpleGetAndRemove() {
        this.doGetAndRemove(FunctionalTestUtils.supplyIntKey(), this.simple1, this.simple2);
    }

    public void testReplGetAndRemoveOnNonOwner() {
        this.doGetAndRemove(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplGetAndRemoveOnOwner() {
        this.doGetAndRemove(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistGetAndRemoveOnNonOwner() {
        this.doGetAndRemove(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistGetAndRemoveOnOwner() {
        this.doGetAndRemove(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doGetAndRemove(Supplier<K> keySupplier, ConcurrentMap<K, String> readMap, ConcurrentMap<K, String> writeMap) {
        K key = keySupplier.get();
        AssertJUnit.assertEquals(null, (String)writeMap.put(key, "one"));
        AssertJUnit.assertEquals((String)"one", (String)((String)readMap.get(key)));
        AssertJUnit.assertEquals((String)"one", (String)((String)writeMap.remove(key)));
        AssertJUnit.assertEquals(null, (String)((String)readMap.get(key)));
    }

    public void testLocalContainsKey() {
        this.doContainsKey(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testSimpleContainsKey() {
        this.doContainsKey(FunctionalTestUtils.supplyIntKey(), this.simple1, this.simple2);
    }

    public void testReplContainsKeyOnNonOwner() {
        this.doContainsKey(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplContainsKeyOnOwner() {
        this.doContainsKey(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistContainsKeyOnNonOwner() {
        this.doContainsKey(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistContainsKeyOnOwner() {
        this.doContainsKey(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doContainsKey(Supplier<K> keySupplier, ConcurrentMap<K, String> map1, ConcurrentMap<K, String> map2) {
        K key = keySupplier.get();
        AssertJUnit.assertEquals((boolean)false, (boolean)map1.containsKey(key));
        AssertJUnit.assertEquals(null, (String)map2.put(key, "one"));
        AssertJUnit.assertEquals((boolean)true, (boolean)map1.containsKey(key));
    }

    public void testLocalContainsValue() {
        this.doContainsValue(FunctionalTestUtils.supplyIntKey(), "one", this.local1, this.local2);
    }

    public void testSimpleContainsValue() {
        this.doContainsValue(FunctionalTestUtils.supplyIntKey(), "one", this.simple1, this.simple2);
    }

    public void testReplContainsValueOnNonOwner() {
        this.doContainsValue(this.supplyKeyForCache(0, "repl"), "one", this.repl1, this.repl2);
    }

    public void testReplContainsValueOnOwner() {
        this.doContainsValue(this.supplyKeyForCache(1, "repl"), "one", this.repl1, this.repl2);
    }

    public void testDistContainsValueOnNonOwner() {
        this.doContainsValue(this.supplyKeyForCache(0, "dist"), "one", this.dist1, this.dist2);
    }

    public void testDistContainsValueOnOwner() {
        this.doContainsValue(this.supplyKeyForCache(1, "dist"), "one", this.dist1, this.dist2);
    }

    private <K> void doContainsValue(Supplier<K> keySupplier, String value, ConcurrentMap<K, String> map1, ConcurrentMap<K, String> map2) {
        K key = keySupplier.get();
        AssertJUnit.assertEquals((boolean)false, (boolean)map1.containsValue(value));
        AssertJUnit.assertEquals(null, (String)map2.put(key, value));
        AssertJUnit.assertEquals((boolean)true, (boolean)map1.containsValue(value));
        AssertJUnit.assertEquals((boolean)false, (boolean)map1.containsValue("xxx"));
    }

    public void testLocalSize() {
        this.doSize(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testSimpleSize() {
        this.doSize(FunctionalTestUtils.supplyIntKey(), this.simple1, this.simple2);
    }

    public void testReplSizeOnNonOwner() {
        this.doSize(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplSizeOnOwner() {
        this.doSize(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistSizeOnNonOwner() {
        this.doSize(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistSizeOnOwner() {
        this.doSize(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doSize(Supplier<K> keySupplier, ConcurrentMap<K, String> readMap, ConcurrentMap<K, String> writeMap) {
        K key1 = keySupplier.get();
        K key2 = keySupplier.get();
        AssertJUnit.assertEquals((int)0, (int)readMap.size());
        AssertJUnit.assertEquals(null, (String)writeMap.put(key1, "one"));
        AssertJUnit.assertEquals((int)1, (int)readMap.size());
        AssertJUnit.assertEquals(null, (String)writeMap.put(key2, "two"));
        AssertJUnit.assertEquals((int)2, (int)readMap.size());
        AssertJUnit.assertEquals((String)"one", (String)((String)writeMap.remove(key1)));
        AssertJUnit.assertEquals((int)1, (int)writeMap.size());
        AssertJUnit.assertEquals((String)"two", (String)((String)writeMap.remove(key2)));
        AssertJUnit.assertEquals((int)0, (int)writeMap.size());
    }

    public void testLocalEmpty() {
        this.doEmpty(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testSimpleEmpty() {
        this.doEmpty(FunctionalTestUtils.supplyIntKey(), this.simple1, this.simple2);
    }

    public void testReplEmptyOnNonOwner() {
        this.doEmpty(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplEmptyOnOwner() {
        this.doEmpty(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistEmptyOnNonOwner() {
        this.doEmpty(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistEmptyOnOwner() {
        this.doEmpty(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doEmpty(Supplier<K> keySupplier, ConcurrentMap<K, String> readMap, ConcurrentMap<K, String> writeMap) {
        K key = keySupplier.get();
        AssertJUnit.assertEquals((boolean)true, (boolean)readMap.isEmpty());
        AssertJUnit.assertEquals(null, (String)writeMap.put(key, "one"));
        AssertJUnit.assertEquals((String)"one", (String)((String)readMap.get(key)));
        AssertJUnit.assertEquals((boolean)false, (boolean)readMap.isEmpty());
        AssertJUnit.assertEquals((String)"one", (String)((String)writeMap.remove(key)));
        AssertJUnit.assertEquals((boolean)true, (boolean)readMap.isEmpty());
    }

    public void testLocalPutAll() {
        this.doPutAll(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testSimplePutAll() {
        this.doPutAll(FunctionalTestUtils.supplyIntKey(), this.simple1, this.simple2);
    }

    public void testReplPutAllOnNonOwner() {
        this.doPutAll(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplPutAllOnOwner() {
        this.doPutAll(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistPutAllOnNonOwner() {
        this.doPutAll(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistPutAllOnOwner() {
        this.doPutAll(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doPutAll(Supplier<K> keySupplier, ConcurrentMap<K, String> readMap, ConcurrentMap<K, String> writeMap) {
        K key1 = keySupplier.get();
        K key2 = keySupplier.get();
        K key3 = keySupplier.get();
        AssertJUnit.assertEquals((boolean)true, (boolean)readMap.isEmpty());
        HashMap<K, String> data = new HashMap<K, String>();
        data.put(key1, "one");
        data.put(key2, "two");
        data.put(key3, "two");
        writeMap.putAll(data);
        AssertJUnit.assertEquals((String)"one", (String)((String)readMap.get(key1)));
        AssertJUnit.assertEquals((String)"two", (String)((String)readMap.get(key2)));
        AssertJUnit.assertEquals((String)"two", (String)((String)readMap.get(key3)));
        AssertJUnit.assertEquals((String)"one", (String)((String)writeMap.remove(key1)));
        AssertJUnit.assertEquals((String)"two", (String)((String)writeMap.remove(key2)));
        AssertJUnit.assertEquals((String)"two", (String)((String)writeMap.remove(key3)));
    }

    public void testLocalClear() {
        this.doClear(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testSimpleClear() {
        this.doClear(FunctionalTestUtils.supplyIntKey(), this.simple1, this.simple2);
    }

    public void testReplClearOnNonOwner() {
        this.doClear(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplClearOnOwner() {
        this.doClear(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistClearOnNonOwner() {
        this.doClear(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistClearOnOwner() {
        this.doClear(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doClear(Supplier<K> keySupplier, ConcurrentMap<K, String> readMap, ConcurrentMap<K, String> writeMap) {
        K key1 = keySupplier.get();
        K key2 = keySupplier.get();
        K key3 = keySupplier.get();
        AssertJUnit.assertEquals((boolean)true, (boolean)readMap.isEmpty());
        HashMap<K, String> data = new HashMap<K, String>();
        data.put(key1, "one");
        data.put(key2, "two");
        data.put(key3, "two");
        writeMap.putAll(data);
        AssertJUnit.assertEquals((String)"one", (String)((String)readMap.get(key1)));
        AssertJUnit.assertEquals((String)"two", (String)((String)readMap.get(key2)));
        AssertJUnit.assertEquals((String)"two", (String)((String)readMap.get(key3)));
        writeMap.clear();
        AssertJUnit.assertEquals(null, (String)((String)readMap.get(key1)));
        AssertJUnit.assertEquals(null, (String)((String)readMap.get(key2)));
        AssertJUnit.assertEquals(null, (String)((String)readMap.get(key3)));
    }

    public void testLocalKeyValueAndEntrySets() {
        this.doKeyValueAndEntrySets(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testSimpleKeyValueAndEntrySets() {
        this.doKeyValueAndEntrySets(FunctionalTestUtils.supplyIntKey(), this.simple1, this.simple2);
    }

    public void testReplKeyValueAndEntrySetsOnNonOwner() {
        this.doKeyValueAndEntrySets(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplKeyValueAndEntrySetsOnOwner() {
        this.doKeyValueAndEntrySets(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistKeyValueAndEntrySetsOnNonOwner() {
        this.doKeyValueAndEntrySets(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistKeyValueAndEntrySetsOnOwner() {
        this.doKeyValueAndEntrySets(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doKeyValueAndEntrySets(Supplier<K> keySupplier, ConcurrentMap<K, String> readMap, ConcurrentMap<K, String> writeMap) {
        Object key1 = keySupplier.get();
        Object key2 = keySupplier.get();
        K key3 = keySupplier.get();
        AssertJUnit.assertEquals((boolean)true, (boolean)readMap.isEmpty());
        writeMap.put(key1, "one");
        writeMap.put(key2, "two");
        writeMap.put(key3, "two");
        Set keys = readMap.keySet();
        AssertJUnit.assertEquals((int)3, (int)keys.size());
        HashSet<Object> expectedKeys = new HashSet<Object>(Arrays.asList(key1, key2, key3));
        keys.forEach(expectedKeys::remove);
        AssertJUnit.assertEquals((boolean)true, (boolean)expectedKeys.isEmpty());
        AssertJUnit.assertEquals((boolean)false, (boolean)readMap.isEmpty());
        Collection values = readMap.values();
        AssertJUnit.assertEquals((int)3, (int)values.size());
        HashSet<String> expectedValues = new HashSet<String>(Arrays.asList("one", "two"));
        values.forEach(expectedValues::remove);
        AssertJUnit.assertEquals((boolean)true, (boolean)expectedValues.isEmpty());
        Set entries = readMap.entrySet();
        AssertJUnit.assertEquals((int)3, (int)entries.size());
        entries.forEach(e -> {
            if (e.getKey().equals(key1)) {
                e.setValue("uno");
            } else if (e.getKey().equals(key2)) {
                e.setValue("dos");
            } else {
                e.setValue("dos");
            }
        });
        AssertJUnit.assertEquals((String)"uno", (String)((String)writeMap.remove(key1)));
        AssertJUnit.assertEquals((String)"dos", (String)((String)writeMap.remove(key2)));
        AssertJUnit.assertEquals((String)"dos", (String)((String)writeMap.remove(key3)));
    }

    public void testLocalPutIfAbsent() {
        this.doPutIfAbsent(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testSimplePutIfAbsent() {
        this.doPutIfAbsent(FunctionalTestUtils.supplyIntKey(), this.simple1, this.simple2);
    }

    public void testReplPutIfAbsentOnNonOwner() {
        this.doPutIfAbsent(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplPutIfAbsentOnOwner() {
        this.doPutIfAbsent(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistPutIfAbsentOnNonOwner() {
        this.doPutIfAbsent(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistPutIfAbsentOnOwner() {
        this.doPutIfAbsent(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doPutIfAbsent(Supplier<K> keySupplier, ConcurrentMap<K, String> readMap, ConcurrentMap<K, String> writeMap) {
        K key = keySupplier.get();
        AssertJUnit.assertEquals(null, (String)((String)readMap.get(key)));
        AssertJUnit.assertEquals(null, (String)writeMap.putIfAbsent(key, "one"));
        AssertJUnit.assertEquals((String)"one", (String)((String)readMap.get(key)));
        AssertJUnit.assertEquals((String)"one", (String)writeMap.putIfAbsent(key, "uno"));
        AssertJUnit.assertEquals((String)"one", (String)((String)readMap.get(key)));
        AssertJUnit.assertEquals((String)"one", (String)((String)writeMap.remove(key)));
        AssertJUnit.assertEquals(null, (String)((String)readMap.get(key)));
    }

    public void testLocalConditionalRemove() {
        this.doConditionalRemove(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testSimpleConditionalRemove() {
        this.doConditionalRemove(FunctionalTestUtils.supplyIntKey(), this.simple1, this.simple2);
    }

    public void testReplConditionalRemoveOnNonOwner() {
        this.doConditionalRemove(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplConditionalRemoveOnOwner() {
        this.doConditionalRemove(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistConditionalRemoveOnNonOwner() {
        this.doConditionalRemove(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistConditionalRemoveOnOwner() {
        this.doConditionalRemove(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doConditionalRemove(Supplier<K> keySupplier, ConcurrentMap<K, String> readMap, ConcurrentMap<K, String> writeMap) {
        K key = keySupplier.get();
        AssertJUnit.assertEquals(null, (String)((String)readMap.get(key)));
        AssertJUnit.assertFalse((boolean)writeMap.remove(key, "xxx"));
        AssertJUnit.assertEquals(null, (String)writeMap.put(key, "one"));
        AssertJUnit.assertEquals((String)"one", (String)((String)readMap.get(key)));
        AssertJUnit.assertFalse((boolean)writeMap.remove(key, "xxx"));
        AssertJUnit.assertEquals((String)"one", (String)((String)readMap.get(key)));
        AssertJUnit.assertTrue((boolean)writeMap.remove(key, "one"));
        AssertJUnit.assertEquals(null, (String)((String)readMap.get(key)));
    }

    public void testLocalReplace() {
        this.doReplace(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testSimpleReplace() {
        this.doReplace(FunctionalTestUtils.supplyIntKey(), this.simple1, this.simple2);
    }

    public void testReplReplaceOnNonOwner() {
        this.doReplace(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplReplaceOnOwner() {
        this.doReplace(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistReplaceOnNonOwner() {
        this.doReplace(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistReplaceOnOwner() {
        this.doReplace(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doReplace(Supplier<K> keySupplier, ConcurrentMap<K, String> readMap, ConcurrentMap<K, String> writeMap) {
        K key = keySupplier.get();
        AssertJUnit.assertEquals(null, (String)((String)readMap.get(key)));
        AssertJUnit.assertEquals(null, (String)writeMap.replace(key, "xxx"));
        AssertJUnit.assertEquals(null, (String)writeMap.put(key, "one"));
        AssertJUnit.assertEquals((String)"one", (String)((String)readMap.get(key)));
        AssertJUnit.assertEquals((String)"one", (String)writeMap.replace(key, "uno"));
        AssertJUnit.assertEquals((String)"uno", (String)((String)readMap.get(key)));
        AssertJUnit.assertEquals((String)"uno", (String)((String)writeMap.remove(key)));
        AssertJUnit.assertEquals(null, (String)((String)readMap.get(key)));
    }

    public void testLocalReplaceWithValue() {
        this.doReplaceWithValue(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testSimpleReplaceWithValue() {
        this.doReplaceWithValue(FunctionalTestUtils.supplyIntKey(), this.simple1, this.simple2);
    }

    public void testReplReplaceWithValueOnNonOwner() {
        this.doReplaceWithValue(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplReplaceWithValueOnOwner() {
        this.doReplaceWithValue(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistReplaceWithValueOnNonOwner() {
        this.doReplaceWithValue(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistReplaceWithValueOnOwner() {
        this.doReplaceWithValue(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doReplaceWithValue(Supplier<K> keySupplier, ConcurrentMap<K, String> readMap, ConcurrentMap<K, String> writeMap) {
        K key = keySupplier.get();
        AssertJUnit.assertEquals(null, (String)((String)readMap.get(key)));
        AssertJUnit.assertFalse((boolean)writeMap.replace(key, "xxx", "uno"));
        AssertJUnit.assertEquals(null, (String)writeMap.put(key, "one"));
        AssertJUnit.assertEquals((String)"one", (String)((String)readMap.get(key)));
        AssertJUnit.assertFalse((boolean)writeMap.replace(key, "xxx", "uno"));
        AssertJUnit.assertEquals((String)"one", (String)((String)readMap.get(key)));
        AssertJUnit.assertTrue((boolean)writeMap.replace(key, "one", "uno"));
        AssertJUnit.assertEquals((String)"uno", (String)((String)readMap.get(key)));
        AssertJUnit.assertEquals((String)"uno", (String)((String)writeMap.remove(key)));
        AssertJUnit.assertEquals(null, (String)((String)readMap.get(key)));
    }
}

