/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional;

import java.util.Arrays;
import java.util.Collection;
import org.infinispan.functional.FunctionalListenerAssertions;
import org.infinispan.functional.FunctionalMapTest;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.functional.Listeners;
import org.infinispan.functional.decorators.FunctionalListeners;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="functional.FunctionalMapEventsTest")
public class FunctionalMapEventsTest
extends FunctionalMapTest {
    LocalFunctionalListeners<Integer> simpleL2;
    LocalFunctionalListeners<Integer> localL2;
    LocalFunctionalListeners<Object> replL2;
    LocalFunctionalListeners<Object> distL2;

    @Override
    @BeforeClass
    public void createBeforeClass() throws Throwable {
        super.createBeforeClass();
        this.simpleL2 = new LocalFunctionalListeners(this.fmapS2);
        this.localL2 = new LocalFunctionalListeners(this.fmapL2);
        this.replL2 = new LocalFunctionalListeners(this.fmapR2);
        this.distL2 = new LocalFunctionalListeners(this.fmapD2);
    }

    @Override
    public void testLocalWriteConstantAndReadGetsValue() {
        FunctionalListenerAssertions.assertOrderedEvents(this.localL2, () -> super.testLocalWriteConstantAndReadGetsValue(), FunctionalListenerAssertions.write("one"));
    }

    @Override
    public void testSimpleWriteConstantAndReadGetsValue() {
        FunctionalListenerAssertions.assertOrderedEvents(this.simpleL2, () -> super.testSimpleWriteConstantAndReadGetsValue(), FunctionalListenerAssertions.write("one"));
    }

    @Override
    public void testReplWriteConstantAndReadGetsValueOnNonOwner() {
        FunctionalListenerAssertions.assertOrderedEvents(this.replL2, () -> super.testReplWriteConstantAndReadGetsValueOnNonOwner(), FunctionalListenerAssertions.write("one"));
    }

    @Override
    public void testReplWriteConstantAndReadGetsValueOnOwner() {
        FunctionalListenerAssertions.assertOrderedEvents(this.replL2, () -> super.testReplWriteConstantAndReadGetsValueOnOwner(), FunctionalListenerAssertions.write("one"));
    }

    @Override
    public void testDistWriteConstantAndReadGetsValueOnNonOwner() {
        FunctionalListenerAssertions.assertNoEvents(this.distL2, () -> super.testDistWriteConstantAndReadGetsValueOnNonOwner());
    }

    @Override
    public void testDistWriteConstantAndReadGetsValueOnOwner() {
        FunctionalListenerAssertions.assertOrderedEvents(this.distL2, () -> super.testDistWriteConstantAndReadGetsValueOnOwner(), FunctionalListenerAssertions.write("one"));
    }

    @Override
    public void testLocalWriteValueAndReadValueAndMetadata() {
        FunctionalListenerAssertions.assertOrderedEvents(this.localL2, () -> super.testLocalWriteValueAndReadValueAndMetadata(), FunctionalListenerAssertions.write("one"));
    }

    @Override
    public void testSimpleWriteValueAndReadValueAndMetadata() {
        FunctionalListenerAssertions.assertOrderedEvents(this.simpleL2, () -> super.testSimpleWriteValueAndReadValueAndMetadata(), FunctionalListenerAssertions.write("one"));
    }

    @Override
    public void testReplWriteValueAndReadValueAndMetadataOnNonOwner() {
        FunctionalListenerAssertions.assertOrderedEvents(this.replL2, () -> super.testReplWriteValueAndReadValueAndMetadataOnNonOwner(), FunctionalListenerAssertions.write("one"));
    }

    @Override
    public void testReplWriteValueAndReadValueAndMetadataOnOwner() {
        FunctionalListenerAssertions.assertOrderedEvents(this.replL2, () -> super.testReplWriteValueAndReadValueAndMetadataOnOwner(), FunctionalListenerAssertions.write("one"));
    }

    @Override
    public void testDistWriteValueAndReadValueAndMetadataOnNonOwner() {
        FunctionalListenerAssertions.assertNoEvents(this.distL2, () -> super.testDistWriteValueAndReadValueAndMetadataOnNonOwner());
    }

    @Override
    public void testDistWriteValueAndReadValueAndMetadataOnOwner() {
        FunctionalListenerAssertions.assertOrderedEvents(this.distL2, () -> super.testDistWriteValueAndReadValueAndMetadataOnOwner(), FunctionalListenerAssertions.write("one"));
    }

    @Override
    public void testLocalReadWriteGetsEmpty() {
        FunctionalListenerAssertions.assertNoEvents(this.localL2, () -> super.testLocalReadWriteGetsEmpty());
    }

    @Override
    public void testSimpleReadWriteGetsEmpty() {
        FunctionalListenerAssertions.assertNoEvents(this.simpleL2, () -> super.testSimpleReadWriteGetsEmpty());
    }

    @Override
    public void testReplReadWriteGetsEmptyOnNonOwner() {
        FunctionalListenerAssertions.assertNoEvents(this.replL2, () -> super.testReplReadWriteGetsEmptyOnNonOwner());
    }

    @Override
    public void testReplReadWriteGetsEmptyOnOwner() {
        FunctionalListenerAssertions.assertNoEvents(this.replL2, () -> super.testReplReadWriteGetsEmptyOnOwner());
    }

    @Override
    public void testDistReadWriteGetsEmptyOnNonOwner() {
        FunctionalListenerAssertions.assertNoEvents(this.distL2, () -> super.testDistReadWriteGetsEmptyOnNonOwner());
    }

    @Override
    public void testDistReadWriteGetsEmptyOnOwner() {
        FunctionalListenerAssertions.assertNoEvents(this.distL2, () -> super.testDistReadWriteGetsEmptyOnOwner());
    }

    @Override
    public void testLocalReadWriteValuesReturnPrevious() {
        FunctionalListenerAssertions.assertOrderedEvents(this.localL2, () -> super.testLocalReadWriteValuesReturnPrevious(), FunctionalListenerAssertions.create("one"));
    }

    @Override
    public void testSimpleReadWriteValuesReturnPrevious() {
        FunctionalListenerAssertions.assertOrderedEvents(this.simpleL2, () -> super.testSimpleReadWriteValuesReturnPrevious(), FunctionalListenerAssertions.create("one"));
    }

    @Override
    public void testReplReadWriteValuesReturnPreviousOnNonOwner() {
        FunctionalListenerAssertions.assertOrderedEvents(this.replL2, () -> super.testReplReadWriteValuesReturnPreviousOnNonOwner(), FunctionalListenerAssertions.create("one"));
    }

    @Override
    public void testReplReadWriteValuesReturnPreviousOnOwner() {
        FunctionalListenerAssertions.assertOrderedEvents(this.replL2, () -> super.testReplReadWriteValuesReturnPreviousOnOwner(), FunctionalListenerAssertions.create("one"));
    }

    @Override
    public void testDistReadWriteValuesReturnPreviousOnNonOwner() {
        FunctionalListenerAssertions.assertNoEvents(this.distL2, () -> super.testDistReadWriteValuesReturnPreviousOnNonOwner());
    }

    @Override
    public void testDistReadWriteValuesReturnPreviousOnOwner() {
        FunctionalListenerAssertions.assertOrderedEvents(this.distL2, () -> super.testDistReadWriteValuesReturnPreviousOnOwner(), FunctionalListenerAssertions.create("one"));
    }

    @Override
    public void testLocalReadWriteForConditionalParamBasedReplace() {
        Collection events = FunctionalMapEventsTest.createUpdateCreate();
        FunctionalListenerAssertions.assertOrderedEvents(this.localL2, () -> super.testLocalReadWriteForConditionalParamBasedReplace(), events);
    }

    @Override
    public void testSimpleReadWriteForConditionalParamBasedReplace() {
        Collection events = FunctionalMapEventsTest.createUpdateCreate();
        FunctionalListenerAssertions.assertOrderedEvents(this.simpleL2, () -> super.testSimpleReadWriteForConditionalParamBasedReplace(), events);
    }

    @Override
    public void testReplReadWriteForConditionalParamBasedReplaceOnNonOwner() {
        FunctionalListenerAssertions.assertOrderedEvents(this.replL2, () -> super.testReplReadWriteForConditionalParamBasedReplaceOnNonOwner(), FunctionalMapEventsTest.createUpdateCreate());
    }

    @Override
    public void testReplReadWriteForConditionalParamBasedReplaceOnOwner() {
        FunctionalListenerAssertions.assertOrderedEvents(this.replL2, () -> super.testReplReadWriteForConditionalParamBasedReplaceOnOwner(), FunctionalMapEventsTest.createUpdateCreate());
    }

    @Override
    public void testDistReadWriteForConditionalParamBasedReplaceOnNonOwner() {
        FunctionalListenerAssertions.assertNoEvents(this.distL2, () -> super.testDistReadWriteForConditionalParamBasedReplaceOnNonOwner());
    }

    @Override
    public void testDistReadWriteForConditionalParamBasedReplaceOnOwner() {
        FunctionalListenerAssertions.assertOrderedEvents(this.distL2, () -> super.testDistReadWriteForConditionalParamBasedReplaceOnOwner(), FunctionalMapEventsTest.createUpdateCreate());
    }

    @Override
    public void testLocalReadOnlyEvalManyEmpty() {
        FunctionalListenerAssertions.assertNoEvents(this.localL2, () -> super.testLocalReadOnlyEvalManyEmpty());
    }

    @Override
    public void testSimpleReadOnlyEvalManyEmpty() {
        FunctionalListenerAssertions.assertNoEvents(this.simpleL2, () -> super.testSimpleReadOnlyEvalManyEmpty());
    }

    @Override
    public void testReplReadOnlyEvalManyEmptyOnNonOwner() {
        FunctionalListenerAssertions.assertNoEvents(this.replL2, () -> super.testReplReadOnlyEvalManyEmptyOnNonOwner());
    }

    @Override
    public void testReplReadOnlyEvalManyEmptyOnOwner() {
        FunctionalListenerAssertions.assertNoEvents(this.replL2, () -> super.testReplReadOnlyEvalManyEmptyOnOwner());
    }

    @Override
    public void testDistReadOnlyEvalManyEmptyOnNonOwner() {
        FunctionalListenerAssertions.assertNoEvents(this.distL2, () -> super.testDistReadOnlyEvalManyEmptyOnNonOwner());
    }

    @Override
    public void testDistReadOnlyEvalManyEmptyOnOwner() {
        FunctionalListenerAssertions.assertNoEvents(this.distL2, () -> super.testDistReadOnlyEvalManyEmptyOnOwner());
    }

    @Override
    public void testLocalUpdateSubsetAndReturnPrevs() {
        FunctionalListenerAssertions.assertUnorderedEvents(this.localL2, () -> super.testLocalUpdateSubsetAndReturnPrevs(), FunctionalListenerAssertions.writeModify(Arrays.asList("one", "two", "three"), Arrays.asList("bat", "bi", "hiru")));
    }

    @Override
    public void testSimpleUpdateSubsetAndReturnPrevs() {
        FunctionalListenerAssertions.assertUnorderedEvents(this.simpleL2, () -> super.testSimpleUpdateSubsetAndReturnPrevs(), FunctionalListenerAssertions.writeModify(Arrays.asList("one", "two", "three"), Arrays.asList("bat", "bi", "hiru")));
    }

    @Override
    public void testReplUpdateSubsetAndReturnPrevsOnNonOwner() {
        FunctionalListenerAssertions.assertUnorderedEvents(this.replL2, () -> super.testReplUpdateSubsetAndReturnPrevsOnNonOwner(), FunctionalListenerAssertions.writeModify(Arrays.asList("one", "two", "three"), Arrays.asList("bat", "bi", "hiru")));
    }

    @Override
    public void testReplUpdateSubsetAndReturnPrevsOnOwner() {
        FunctionalListenerAssertions.assertUnorderedEvents(this.replL2, () -> super.testReplUpdateSubsetAndReturnPrevsOnOwner(), FunctionalListenerAssertions.writeModify(Arrays.asList("one", "two", "three"), Arrays.asList("bat", "bi", "hiru")));
    }

    @Override
    public void testDistUpdateSubsetAndReturnPrevsOnNonOwner() {
        FunctionalListenerAssertions.assertNoEvents(this.distL2, () -> super.testDistUpdateSubsetAndReturnPrevsOnNonOwner());
    }

    @Override
    public void testDistUpdateSubsetAndReturnPrevsOnOwner() {
        FunctionalListenerAssertions.assertUnorderedEvents(this.distL2, () -> super.testDistUpdateSubsetAndReturnPrevsOnOwner(), FunctionalListenerAssertions.writeModify(Arrays.asList("one", "two", "three"), Arrays.asList("bat", "bi", "hiru")));
    }

    @Override
    public void testLocalReadWriteToRemoveAllAndReturnPrevs() {
        FunctionalListenerAssertions.assertUnorderedEvents(this.localL2, () -> super.testLocalReadWriteToRemoveAllAndReturnPrevs(), FunctionalListenerAssertions.writeRemove("one", "two", "three"));
    }

    @Override
    public void testSimpleReadWriteToRemoveAllAndReturnPrevs() {
        FunctionalListenerAssertions.assertUnorderedEvents(this.simpleL2, () -> super.testSimpleReadWriteToRemoveAllAndReturnPrevs(), FunctionalListenerAssertions.writeRemove("one", "two", "three"));
    }

    @Override
    public void testReplReadWriteToRemoveAllAndReturnPrevsOnNonOwner() {
        FunctionalListenerAssertions.assertUnorderedEvents(this.replL2, () -> super.testReplReadWriteToRemoveAllAndReturnPrevsOnNonOwner(), FunctionalListenerAssertions.writeRemove("one", "two", "three"));
    }

    @Override
    public void testReplReadWriteToRemoveAllAndReturnPrevsOnOwner() {
        FunctionalListenerAssertions.assertUnorderedEvents(this.replL2, () -> super.testReplReadWriteToRemoveAllAndReturnPrevsOnOwner(), FunctionalListenerAssertions.writeRemove("one", "two", "three"));
    }

    @Override
    public void testDistReadWriteToRemoveAllAndReturnPrevsOnNonOwner() {
        FunctionalListenerAssertions.assertNoEvents(this.distL2, () -> super.testDistReadWriteToRemoveAllAndReturnPrevsOnNonOwner());
    }

    @Override
    public void testDistReadWriteToRemoveAllAndReturnPrevsOnOwner() {
        FunctionalListenerAssertions.assertUnorderedEvents(this.distL2, () -> super.testDistReadWriteToRemoveAllAndReturnPrevsOnOwner(), FunctionalListenerAssertions.writeRemove("one", "two", "three"));
    }

    static Collection<FunctionalListenerAssertions.TestEvent<String>> createUpdateCreate() {
        Collection<FunctionalListenerAssertions.TestEvent<String>> events = FunctionalListenerAssertions.createModify("one", "uno");
        events.addAll(FunctionalListenerAssertions.create("one"));
        return events;
    }

    private static final class LocalFunctionalListeners<K>
    implements FunctionalListeners<K, String> {
        private final FunctionalMapImpl<K, String> fmap;

        private LocalFunctionalListeners(FunctionalMapImpl<K, String> fmap) {
            this.fmap = fmap;
        }

        @Override
        public Listeners.ReadWriteListeners<K, String> readWriteListeners() {
            return FunctionalTestUtils.rw(this.fmap).listeners();
        }

        @Override
        public Listeners.WriteListeners<K, String> writeOnlyListeners() {
            return FunctionalTestUtils.wo(this.fmap).listeners();
        }
    }
}

