/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.Consumer;
import java.util.function.Function;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;

public class TestFunctionalInterfaces {

    @SerializeWith(value=Externalizer0.class)
    public static final class SetConstantOnWriteOnly<K>
    implements Consumer<EntryView.WriteEntryView<K, String>> {
        final String constant;

        public SetConstantOnWriteOnly(String constant) {
            this.constant = constant;
        }

        @Override
        public void accept(EntryView.WriteEntryView<K, String> wo) {
            wo.set((Object)this.constant, new MetaParam.Writable[0]);
        }

        public static final class Externalizer0
        implements Externalizer<SetConstantOnWriteOnly> {
            public void writeObject(ObjectOutput output, SetConstantOnWriteOnly object) throws IOException {
                output.writeUTF(object.constant);
            }

            public SetConstantOnWriteOnly readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                String constant = input.readUTF();
                return new SetConstantOnWriteOnly(constant);
            }
        }
    }

    @SerializeWith(value=Externalizer0.class)
    public static final class SetConstantOnReadWrite<K>
    implements Function<EntryView.ReadWriteEntryView<K, String>, Void> {
        final String constant;

        public SetConstantOnReadWrite(String constant) {
            this.constant = constant;
        }

        @Override
        public Void apply(EntryView.ReadWriteEntryView<K, String> rw) {
            rw.set((Object)this.constant, new MetaParam.Writable[0]);
            return null;
        }

        public static final class Externalizer0
        implements Externalizer<SetConstantOnReadWrite<?>> {
            public void writeObject(ObjectOutput output, SetConstantOnReadWrite<?> object) throws IOException {
                output.writeUTF(object.constant);
            }

            public SetConstantOnReadWrite<?> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                String constant = input.readUTF();
                return new SetConstantOnReadWrite(constant);
            }
        }
    }
}

