/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.BaseAsyncInterceptor;
import org.infinispan.interceptors.impl.AsyncInterceptorChainImpl;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="interceptors.AsyncInterceptorChainTest")
public class AsyncInterceptorChainTest
extends AbstractInfinispanTest {
    private static final Log log = LogFactory.getLog(AsyncInterceptorChainTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentAddRemove() throws Exception {
        AsyncInterceptorChainImpl ic = new AsyncInterceptorChainImpl();
        ic.addInterceptor((AsyncInterceptor)new DummyCallInterceptor(), 0);
        ic.addInterceptor((AsyncInterceptor)new DummyActivationInterceptor(), 1);
        CyclicBarrier barrier = new CyclicBarrier(4);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(2);
        ExecutorService executorService = Executors.newFixedThreadPool(3, this.getTestThreadFactory("Worker"));
        try {
            futures.add(executorService.submit(new InterceptorChainUpdater((AsyncInterceptorChain)ic, barrier, (AsyncInterceptor)new DummyCacheMgmtInterceptor())));
            futures.add(executorService.submit(new InterceptorChainUpdater((AsyncInterceptorChain)ic, barrier, (AsyncInterceptor)new DummyDistCacheWriterInterceptor())));
            futures.add(executorService.submit(new InterceptorChainUpdater((AsyncInterceptorChain)ic, barrier, (AsyncInterceptor)new DummyInvalidationInterceptor())));
            barrier.await();
            barrier.await();
            log.debug((Object)"All threads finished, let's shutdown the executor and check whether any exceptions were reported");
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            executorService.shutdownNow();
        }
        assert (ic.containsInterceptorType(DummyCallInterceptor.class));
        assert (ic.containsInterceptorType(DummyActivationInterceptor.class));
        assert (ic.containsInterceptorType(DummyCacheMgmtInterceptor.class));
        assert (ic.containsInterceptorType(DummyDistCacheWriterInterceptor.class));
        assert (ic.containsInterceptorType(DummyInvalidationInterceptor.class));
        assert (ic.getInterceptors().size() == 5) : "Resulting interceptor chain was actually " + String.valueOf(ic.getInterceptors());
    }

    static class DummyCallInterceptor
    extends BaseAsyncInterceptor {
        DummyCallInterceptor() {
        }

        public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
            return null;
        }
    }

    static class DummyActivationInterceptor
    extends DummyCallInterceptor {
        DummyActivationInterceptor() {
        }
    }

    private static class InterceptorChainUpdater
    implements Callable<Void> {
        private final AsyncInterceptorChain ic;
        private final CyclicBarrier barrier;
        private final AsyncInterceptor interceptor;

        InterceptorChainUpdater(AsyncInterceptorChain ic, CyclicBarrier barrier, AsyncInterceptor interceptor) {
            this.ic = ic;
            this.barrier = barrier;
            this.interceptor = interceptor;
        }

        @Override
        public Void call() throws Exception {
            Class interceptorClass = this.interceptor.getClass();
            try {
                log.debug((Object)"Wait for all executions paths to be ready to perform calls");
                this.barrier.await();
                for (int i = 0; i < 2000; ++i) {
                    this.ic.removeInterceptor(interceptorClass);
                    this.ic.addInterceptor(this.interceptor, 1);
                }
                Void void_ = null;
                return void_;
            }
            finally {
                log.debug((Object)"Wait for all execution paths to finish");
                this.barrier.await();
            }
        }
    }

    static class DummyCacheMgmtInterceptor
    extends DummyCallInterceptor {
        DummyCacheMgmtInterceptor() {
        }
    }

    static class DummyDistCacheWriterInterceptor
    extends DummyCallInterceptor {
        DummyDistCacheWriterInterceptor() {
        }
    }

    static class DummyInvalidationInterceptor
    extends DummyCallInterceptor {
        DummyInvalidationInterceptor() {
        }
    }
}

