/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.SingleKeyNonTxInvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseAsyncInterceptor;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.impl.CacheMgmtInterceptor;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestException;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="interceptors.impl.CacheMgmtInterceptorTest")
public class CacheMgmtInterceptorTest
extends AbstractInfinispanTest {
    public static final String KEY = "key";
    public static final String VALUE = "value";
    private CacheMgmtInterceptor interceptor;
    private ControlledNextInterceptor nextInterceptor;
    private ControlledTimeService timeService;
    private InvocationContext ctx;

    @BeforeMethod(alwaysRun=true)
    public void setup() {
        this.nextInterceptor = new ControlledNextInterceptor();
        this.timeService = new ControlledTimeService();
        this.ctx = new SingleKeyNonTxInvocationContext(null);
        this.interceptor = new CacheMgmtInterceptor();
        this.interceptor.setNextInterceptor((AsyncInterceptor)this.nextInterceptor);
        TestingUtil.inject(this.interceptor, this.timeService);
        this.interceptor.start();
        this.interceptor.setStatisticsEnabled(true);
    }

    public void testVisitGetKeyValueCommand() throws Throwable {
        GetKeyValueCommand command = new GetKeyValueCommand((Object)KEY, 0, 0L);
        InvocationStage stage = BaseAsyncInterceptor.makeStage((Object)this.interceptor.visitGetKeyValueCommand(this.ctx, command));
        AssertJUnit.assertFalse((boolean)stage.isDone());
        this.timeService.advance(1L);
        this.nextInterceptor.completeLastInvocation(null);
        AssertJUnit.assertNull((Object)stage.get());
        AssertJUnit.assertEquals((long)1L, (long)this.interceptor.getAverageReadTime());
    }

    public void testVisitGetKeyValueCommandException() throws Throwable {
        GetKeyValueCommand command = new GetKeyValueCommand((Object)KEY, 0, 0L);
        InvocationStage stage = BaseAsyncInterceptor.makeStage((Object)this.interceptor.visitGetKeyValueCommand(this.ctx, command));
        AssertJUnit.assertFalse((boolean)stage.isDone());
        this.timeService.advance(1L);
        this.nextInterceptor.completeLastInvocationExceptionally(new TestException());
        this.expectInvocationException(stage);
        AssertJUnit.assertEquals((long)1L, (long)this.interceptor.getAverageReadTime());
    }

    public void testVisitGetCacheEntryCommand() throws Throwable {
        GetCacheEntryCommand command = new GetCacheEntryCommand((Object)KEY, 0, 0L);
        InvocationStage stage = BaseAsyncInterceptor.makeStage((Object)this.interceptor.visitGetCacheEntryCommand(this.ctx, command));
        AssertJUnit.assertFalse((boolean)stage.isDone());
        this.timeService.advance(1L);
        this.nextInterceptor.completeLastInvocation(null);
        AssertJUnit.assertNull((Object)stage.get());
        AssertJUnit.assertEquals((long)1L, (long)this.interceptor.getAverageReadTime());
    }

    public void testVisitGetCacheEntryCommandException() throws Throwable {
        GetCacheEntryCommand command = new GetCacheEntryCommand((Object)KEY, 0, 0L);
        InvocationStage stage = BaseAsyncInterceptor.makeStage((Object)this.interceptor.visitGetCacheEntryCommand(this.ctx, command));
        AssertJUnit.assertFalse((boolean)stage.isDone());
        this.timeService.advance(1L);
        this.nextInterceptor.completeLastInvocationExceptionally(new TestException());
        this.expectInvocationException(stage);
        AssertJUnit.assertEquals((long)1L, (long)this.interceptor.getAverageReadTime());
    }

    public void testVisitGetAllCommand() throws Throwable {
        GetAllCommand command = new GetAllCommand(Collections.singleton(KEY), 0L, false);
        InvocationStage stage = BaseAsyncInterceptor.makeStage((Object)this.interceptor.visitGetAllCommand(this.ctx, command));
        AssertJUnit.assertFalse((boolean)stage.isDone());
        this.timeService.advance(1L);
        this.nextInterceptor.completeLastInvocation(Collections.emptyMap());
        AssertJUnit.assertEquals(Collections.emptyMap(), (Object)stage.get());
        AssertJUnit.assertEquals((long)1L, (long)this.interceptor.getAverageReadTime());
    }

    public void testVisitGetAllCommandException() throws Throwable {
        GetAllCommand command = new GetAllCommand(Collections.singleton(KEY), 0L, false);
        InvocationStage stage = BaseAsyncInterceptor.makeStage((Object)this.interceptor.visitGetAllCommand(this.ctx, command));
        AssertJUnit.assertFalse((boolean)stage.isDone());
        this.timeService.advance(1L);
        this.nextInterceptor.completeLastInvocationExceptionally(new TestException());
        this.expectInvocationException(stage);
        AssertJUnit.assertEquals((long)1L, (long)this.interceptor.getAverageReadTime());
    }

    public void testVisitPutMapCommand() throws Throwable {
        PutMapCommand command = new PutMapCommand(Collections.singletonMap(KEY, VALUE), null, 0L, null);
        InvocationStage stage = BaseAsyncInterceptor.makeStage((Object)this.interceptor.visitPutMapCommand(this.ctx, command));
        AssertJUnit.assertFalse((boolean)stage.isDone());
        this.timeService.advance(1L);
        this.nextInterceptor.completeLastInvocation(null);
        AssertJUnit.assertNull((Object)stage.get());
        AssertJUnit.assertEquals((long)1L, (long)this.interceptor.getAverageWriteTime());
    }

    public void testVisitPutMapCommandException() throws Throwable {
        PutMapCommand command = new PutMapCommand(Collections.singletonMap(KEY, VALUE), null, 0L, null);
        InvocationStage stage = BaseAsyncInterceptor.makeStage((Object)this.interceptor.visitPutMapCommand(this.ctx, command));
        AssertJUnit.assertFalse((boolean)stage.isDone());
        this.timeService.advance(1L);
        this.nextInterceptor.completeLastInvocationExceptionally(new TestException());
        this.expectInvocationException(stage);
        AssertJUnit.assertEquals((long)1L, (long)this.interceptor.getAverageWriteTime());
    }

    public void testVisitPutKeyValueCommand() throws Throwable {
        PutKeyValueCommand command = new PutKeyValueCommand((Object)KEY, (Object)VALUE, false, false, null, 0, 0L, null);
        InvocationStage stage = BaseAsyncInterceptor.makeStage((Object)this.interceptor.visitPutKeyValueCommand(this.ctx, command));
        AssertJUnit.assertFalse((boolean)stage.isDone());
        this.timeService.advance(1L);
        this.nextInterceptor.completeLastInvocation(null);
        AssertJUnit.assertNull((Object)stage.get());
        AssertJUnit.assertEquals((long)1L, (long)this.interceptor.getAverageWriteTime());
    }

    public void testVisitPutKeyValueCommandException() throws Throwable {
        PutKeyValueCommand command = new PutKeyValueCommand((Object)KEY, (Object)VALUE, false, false, null, 0, 0L, null);
        InvocationStage stage = BaseAsyncInterceptor.makeStage((Object)this.interceptor.visitPutKeyValueCommand(this.ctx, command));
        AssertJUnit.assertFalse((boolean)stage.isDone());
        this.timeService.advance(1L);
        this.nextInterceptor.completeLastInvocationExceptionally(new TestException());
        this.expectInvocationException(stage);
        AssertJUnit.assertEquals((long)1L, (long)this.interceptor.getAverageWriteTime());
    }

    public void testVisitReplaceCommand() throws Throwable {
        ReplaceCommand command = new ReplaceCommand((Object)KEY, (Object)VALUE, (Object)false, false, null, 0, 0L, null);
        InvocationStage stage = BaseAsyncInterceptor.makeStage((Object)this.interceptor.visitReplaceCommand(this.ctx, command));
        AssertJUnit.assertFalse((boolean)stage.isDone());
        this.timeService.advance(1L);
        this.nextInterceptor.completeLastInvocation(null);
        AssertJUnit.assertNull((Object)stage.get());
        AssertJUnit.assertEquals((long)1L, (long)this.interceptor.getAverageWriteTime());
    }

    public void testVisitReplaceCommandException() throws Throwable {
        ReplaceCommand command = new ReplaceCommand((Object)KEY, (Object)VALUE, (Object)false, false, null, 0, 0L, null);
        InvocationStage stage = BaseAsyncInterceptor.makeStage((Object)this.interceptor.visitReplaceCommand(this.ctx, command));
        AssertJUnit.assertFalse((boolean)stage.isDone());
        this.timeService.advance(1L);
        this.nextInterceptor.completeLastInvocationExceptionally(new TestException());
        this.expectInvocationException(stage);
        AssertJUnit.assertEquals((long)1L, (long)this.interceptor.getAverageWriteTime());
    }

    public void testVisitRemoveCommand() throws Throwable {
        RemoveCommand command = new RemoveCommand((Object)KEY, null, false, 0, 0L, null);
        InvocationStage stage = BaseAsyncInterceptor.makeStage((Object)this.interceptor.visitRemoveCommand(this.ctx, command));
        AssertJUnit.assertFalse((boolean)stage.isDone());
        this.timeService.advance(1L);
        this.nextInterceptor.completeLastInvocation(VALUE);
        AssertJUnit.assertEquals((Object)VALUE, (Object)stage.get());
        AssertJUnit.assertEquals((long)1L, (long)this.interceptor.getAverageRemoveTime());
    }

    public void testVisitRemoveCommandException() throws Throwable {
        RemoveCommand command = new RemoveCommand((Object)KEY, null, false, 0, 0L, null);
        InvocationStage stage = BaseAsyncInterceptor.makeStage((Object)this.interceptor.visitRemoveCommand(this.ctx, command));
        AssertJUnit.assertFalse((boolean)stage.isDone());
        this.timeService.advance(1L);
        this.nextInterceptor.completeLastInvocationExceptionally(new TestException());
        this.expectInvocationException(stage);
        AssertJUnit.assertEquals((long)0L, (long)this.interceptor.getAverageRemoveTime());
    }

    private void expectInvocationException(InvocationStage stage) {
        Exceptions.expectException(TestException.class, () -> {
            try {
                stage.get();
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable t) {
                throw new Exception(t);
            }
        });
    }

    static class ControlledNextInterceptor
    extends BaseAsyncInterceptor {
        CompletableFuture<Object> lastReturnValue;

        ControlledNextInterceptor() {
        }

        public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
            this.lastReturnValue = new CompletableFuture();
            return ControlledNextInterceptor.asyncValue(this.lastReturnValue);
        }

        public void completeLastInvocation(Object value) {
            this.lastReturnValue.complete(value);
        }

        public void completeLastInvocationExceptionally(Throwable t) {
            this.lastReturnValue.completeExceptionally(t);
        }
    }
}

