/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.concurrent.CompletableFuture;
import org.infinispan.interceptors.InvocationCallback;
import org.infinispan.interceptors.impl.QueueAsyncInvocationStage;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="interceptors.QueueAsyncInvocationStageTest")
public class QueueAsyncInvocationStageTest
extends AbstractInfinispanTest {
    @DataProvider(name="offsets")
    public Object[][] offsets() {
        return new Object[][]{{0}, {1}};
    }

    @Test(dataProvider="offsets")
    public void testExpandCapacity(int splitOffset) throws Throwable {
        CompletableFuture future = new CompletableFuture();
        QueueAsyncInvocationStage stage = new QueueAsyncInvocationStage(null, null, future, this.makeCallback(0));
        this.assertCallback(0, stage.queuePoll());
        this.addAndPoll(stage, splitOffset);
        int count = 16;
        this.addAndPoll(stage, count);
    }

    private InvocationCallback makeCallback(int i) {
        return (rCtx, rCommand, rv, throwable) -> "v" + i;
    }

    private void assertCallback(int index, InvocationCallback callback) throws Throwable {
        AssertJUnit.assertEquals((Object)("v" + index), (Object)callback.apply(null, null, null, null));
    }

    private void addAndPoll(QueueAsyncInvocationStage stage, int splitOffset) throws Throwable {
        int i;
        for (i = 0; i < splitOffset; ++i) {
            stage.queueAdd(this.makeCallback(i));
        }
        AssertJUnit.assertEquals((int)splitOffset, (int)stage.queueSize());
        for (i = 0; i < splitOffset; ++i) {
            this.assertCallback(i, stage.queuePoll());
        }
        AssertJUnit.assertEquals((int)0, (int)stage.queueSize());
    }
}

