/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.stream.Stream;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.jmx.AbstractClusterMBeanTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.ClusterContainerStatsMBeanTest")
public class ClusterContainerStatsMBeanTest
extends AbstractClusterMBeanTest {
    private final String componentName;

    public ClusterContainerStatsMBeanTest(String componentName) {
        super(ClusterContainerStatsMBeanTest.class.getName());
        this.componentName = componentName;
    }

    @Override
    public Object[] factory() {
        return Stream.of("ClusterContainerStats", "LocalContainerStats").map(ClusterContainerStatsMBeanTest::new).toArray();
    }

    @Override
    protected String parameters() {
        return String.format("[%s]", this.componentName);
    }

    public void testContainerStats() throws Exception {
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        ObjectName clusterStats = TestingUtil.getCacheManagerObjectName(this.jmxDomain1, "DefaultCacheManager", this.componentName);
        this.assertAttributeValueGreaterThanOrEqualTo(mBeanServer, clusterStats, "MemoryAvailable", 1L);
        this.assertAttributeValueGreaterThanOrEqualTo(mBeanServer, clusterStats, "MemoryMax", 1L);
        this.assertAttributeValueGreaterThanOrEqualTo(mBeanServer, clusterStats, "MemoryTotal", 1L);
        this.assertAttributeValueGreaterThanOrEqualTo(mBeanServer, clusterStats, "MemoryUsed", 1L);
    }
}

