/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.concurrent.ExecutorService;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.ClusteredCacheManagerMBeanTest")
public class ClusteredCacheManagerMBeanTest
extends MultipleCacheManagersTest {
    private static final String JMX_DOMAIN = ClusteredCacheManagerMBeanTest.class.getSimpleName();
    private static final String JMX_DOMAIN2 = JMX_DOMAIN + "2";
    private static final String CACHE_NAME = "mycache";
    private ObjectName name1;
    private ObjectName name2;
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();

    @Override
    protected void createCacheManagers() throws Throwable {
        GlobalConfigurationBuilder globalConfig1 = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.configureJmx(globalConfig1, JMX_DOMAIN, this.mBeanServerLookup);
        ConfigurationBuilder config = ClusteredCacheManagerMBeanTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC);
        config.statistics().enable();
        EmbeddedCacheManager cacheManager1 = TestCacheManagerFactory.createClusteredCacheManager(globalConfig1, config, new TransportFlags());
        cacheManager1.start();
        GlobalConfigurationBuilder globalConfig2 = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.configureJmx(globalConfig2, JMX_DOMAIN2, this.mBeanServerLookup);
        EmbeddedCacheManager cacheManager2 = TestCacheManagerFactory.createClusteredCacheManager(globalConfig2, config, new TransportFlags());
        cacheManager2.start();
        this.registerCacheManager(new CacheContainer[]{cacheManager1, cacheManager2});
        this.name1 = TestingUtil.getCacheManagerObjectName(JMX_DOMAIN);
        this.name2 = TestingUtil.getCacheManagerObjectName(JMX_DOMAIN2);
        this.defineConfigurationOnAllManagers(CACHE_NAME, config);
        this.manager(0).getCache(CACHE_NAME);
        this.manager(1).getCache(CACHE_NAME);
    }

    public void testAddressInformation() throws Exception {
        MBeanServer server = this.mBeanServerLookup.getMBeanServer();
        String cm1Address = this.manager(0).getAddress().toString();
        String cm2Address = this.manager(1).getAddress().toString();
        AssertJUnit.assertEquals((Object)cm1Address, (Object)server.getAttribute(this.name1, "NodeAddress"));
        AssertJUnit.assertTrue((boolean)server.getAttribute(this.name1, "ClusterMembers").toString().contains(cm1Address));
        Assert.assertNotEquals((Object)"local", (Object)server.getAttribute(this.name1, "PhysicalAddresses"));
        AssertJUnit.assertEquals((Object)2, (Object)server.getAttribute(this.name1, "ClusterSize"));
        AssertJUnit.assertEquals((Object)cm2Address, (Object)server.getAttribute(this.name2, "NodeAddress"));
        AssertJUnit.assertTrue((boolean)server.getAttribute(this.name2, "ClusterMembers").toString().contains(cm2Address));
        Assert.assertNotEquals((Object)"local", (Object)server.getAttribute(this.name2, "PhysicalAddresses"));
        AssertJUnit.assertEquals((Object)2, (Object)server.getAttribute(this.name2, "ClusterSize"));
        String cm1members = (String)server.getAttribute(this.name1, "ClusterMembersPhysicalAddresses");
        AssertJUnit.assertEquals((int)2, (int)cm1members.substring(1, cm1members.length() - 2).split(",\\s+").length);
    }

    public void testJGroupsInformation() throws Exception {
        MBeanServer server = this.mBeanServerLookup.getMBeanServer();
        ObjectName jchannelName1 = TestingUtil.getJGroupsChannelObjectName(this.manager(0));
        ObjectName jchannelName2 = TestingUtil.getJGroupsChannelObjectName(this.manager(1));
        AssertJUnit.assertEquals((Object)server.getAttribute(this.name1, "NodeAddress"), (Object)server.getAttribute(jchannelName1, "address"));
        AssertJUnit.assertEquals((Object)server.getAttribute(this.name2, "NodeAddress"), (Object)server.getAttribute(jchannelName2, "address"));
        AssertJUnit.assertTrue((boolean)((Boolean)server.getAttribute(jchannelName1, "connected")));
        AssertJUnit.assertTrue((boolean)((Boolean)server.getAttribute(jchannelName2, "connected")));
    }

    public void testExecutorMBeans() throws Exception {
        MBeanServer server = this.mBeanServerLookup.getMBeanServer();
        ObjectName objectName = TestingUtil.getCacheManagerObjectName(JMX_DOMAIN, "DefaultCacheManager", "org.infinispan.executors.timeout");
        AssertJUnit.assertTrue((boolean)server.isRegistered(objectName));
        AssertJUnit.assertEquals((Object)Integer.MAX_VALUE, (Object)server.getAttribute(objectName, "MaximumPoolSize"));
        String javaVersion = System.getProperty("java.version");
        AssertJUnit.assertEquals((Object)(javaVersion.startsWith("1.8.") ? 0L : 10L), (Object)server.getAttribute(objectName, "KeepAliveTime"));
        ExecutorService executor = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(0), ExecutorService.class, "org.infinispan.executors.non-blocking");
        executor.submit(() -> {});
        objectName = TestingUtil.getCacheManagerObjectName(JMX_DOMAIN, "DefaultCacheManager", "org.infinispan.executors.non-blocking");
        AssertJUnit.assertTrue((boolean)server.isRegistered(objectName));
        AssertJUnit.assertEquals((Object)30000L, (Object)server.getAttribute(objectName, "KeepAliveTime"));
        AssertJUnit.assertEquals((Object)6, (Object)server.getAttribute(objectName, "MaximumPoolSize"));
    }
}

