/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.Cache;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.ClusteredCacheMgmtInterceptorMBeanTest")
public class ClusteredCacheMgmtInterceptorMBeanTest
extends MultipleCacheManagersTest {
    private static final String JMX_DOMAIN_1 = ClusteredCacheMgmtInterceptorMBeanTest.class.getSimpleName() + "-1";
    private static final String JMX_DOMAIN_2 = ClusteredCacheMgmtInterceptorMBeanTest.class.getSimpleName() + "-2";
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();

    @Override
    protected void createCacheManagers() throws Throwable {
        GlobalConfigurationBuilder globalBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.configureJmx(globalBuilder, JMX_DOMAIN_1, this.mBeanServerLookup);
        ConfigurationBuilder builder = ClusteredCacheMgmtInterceptorMBeanTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
        builder.statistics().enable();
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager(globalBuilder, builder);
        GlobalConfigurationBuilder globalBuilder2 = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.configureJmx(globalBuilder2, JMX_DOMAIN_2, this.mBeanServerLookup);
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager(globalBuilder2, builder);
        this.registerCacheManager(new CacheContainer[]{cm1, cm2});
    }

    public void testCorrectStatsInCluster() throws Exception {
        Cache cache1 = this.cache(0);
        Cache cache2 = this.cache(1);
        cache1.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((String)"v", (String)((String)cache2.get((Object)"k")));
        ObjectName stats1 = TestingUtil.getCacheObjectName(JMX_DOMAIN_1, this.getDefaultCacheName() + "(repl_sync)", "Statistics");
        ObjectName stats2 = TestingUtil.getCacheObjectName(JMX_DOMAIN_2, this.getDefaultCacheName() + "(repl_sync)", "Statistics");
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        AssertJUnit.assertEquals((Object)1L, (Object)mBeanServer.getAttribute(stats1, "Stores"));
        AssertJUnit.assertEquals((Object)0L, (Object)mBeanServer.getAttribute(stats2, "Stores"));
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("k1", "v1");
        values.put("k2", "v2");
        values.put("k3", "v3");
        cache2.putAll(values);
        AssertJUnit.assertEquals((Object)1L, (Object)mBeanServer.getAttribute(stats1, "Stores"));
        AssertJUnit.assertEquals((Object)3L, (Object)mBeanServer.getAttribute(stats2, "Stores"));
        cache1.remove((Object)"k");
        AssertJUnit.assertEquals((Object)1L, (Object)mBeanServer.getAttribute(stats1, "RemoveHits"));
        AssertJUnit.assertEquals((Object)0L, (Object)mBeanServer.getAttribute(stats2, "RemoveHits"));
    }
}

