/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.concurrent.Callable;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.ExplicitLockingAndOptimisticCachesTest")
public class ExplicitLockingAndOptimisticCachesTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder c = this.getDefaultStandaloneCacheConfig(true);
        c.transaction().lockingMode(LockingMode.OPTIMISTIC);
        return TestCacheManagerFactory.createCacheManager(c);
    }

    public void testExplicitLockingNotWorkingWithOptimisticCaches() throws Exception {
        TestingUtil.withTx(this.tm(), new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    ExplicitLockingAndOptimisticCachesTest.this.cache.getAdvancedCache().lock(new Object[]{"a"});
                    assert (false);
                }
                catch (CacheException cacheException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void testExplicitLockingOptimisticCachesFailSilent() throws Exception {
        TestingUtil.withTx(this.tm(), new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    ExplicitLockingAndOptimisticCachesTest.this.cache.getAdvancedCache().withFlags(Flag.FAIL_SILENTLY).lock(new Object[]{"a"});
                    assert (false) : "Should be throwing an exception in spite of fail silent";
                }
                catch (CacheException cacheException) {
                    // empty catch block
                }
                return null;
            }
        });
    }
}

