/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commons.TimeoutException;
import org.infinispan.commons.util.ByRef;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.concurrent.locks.DeadlockDetectedException;
import org.infinispan.util.concurrent.locks.ExtendedLockPromise;
import org.infinispan.util.concurrent.locks.LockState;
import org.infinispan.util.concurrent.locks.impl.InfinispanLock;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="lock.InfinispanLockTest")
public class InfinispanLockTest
extends AbstractInfinispanTest {
    public void testTimeout() throws InterruptedException {
        String lockOwner1 = "LO1";
        String lockOwner2 = "LO2";
        InfinispanLock lock = new InfinispanLock((Executor)this.testExecutor(), AbstractCacheTest.TIME_SERVICE);
        ExtendedLockPromise lockPromise1 = lock.acquire((Object)"LO1", 0L, TimeUnit.MILLISECONDS);
        ExtendedLockPromise lockPromise2 = lock.acquire((Object)"LO2", 0L, TimeUnit.MILLISECONDS);
        AssertJUnit.assertTrue((boolean)lockPromise1.isAvailable());
        AssertJUnit.assertTrue((boolean)lockPromise2.isAvailable());
        lockPromise1.lock();
        AssertJUnit.assertEquals((Object)"LO1", (Object)lock.getLockOwner());
        try {
            lockPromise2.lock();
            AssertJUnit.fail();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        lock.release((Object)"LO1");
        AssertJUnit.assertNull((Object)lock.getLockOwner());
        AssertJUnit.assertFalse((boolean)lock.isLocked());
        lock.release((Object)"LO2");
        AssertJUnit.assertFalse((boolean)lock.isLocked());
        AssertJUnit.assertNull((Object)lock.getLockOwner());
    }

    public void testTimeout2() throws InterruptedException {
        String lockOwner1 = "LO1";
        String lockOwner2 = "LO2";
        String lockOwner3 = "LO3";
        InfinispanLock lock = new InfinispanLock((Executor)this.testExecutor(), AbstractCacheTest.TIME_SERVICE);
        ExtendedLockPromise lockPromise1 = lock.acquire((Object)"LO1", 0L, TimeUnit.MILLISECONDS);
        ExtendedLockPromise lockPromise2 = lock.acquire((Object)"LO2", 0L, TimeUnit.MILLISECONDS);
        ExtendedLockPromise lockPromise3 = lock.acquire((Object)"LO3", 1L, TimeUnit.DAYS);
        AssertJUnit.assertTrue((boolean)lockPromise1.isAvailable());
        AssertJUnit.assertTrue((boolean)lockPromise2.isAvailable());
        AssertJUnit.assertFalse((boolean)lockPromise3.isAvailable());
        lockPromise1.lock();
        AssertJUnit.assertEquals((Object)"LO1", (Object)lock.getLockOwner());
        try {
            lockPromise2.lock();
            AssertJUnit.fail();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        lock.release((Object)"LO1");
        AssertJUnit.assertTrue((boolean)lock.isLocked());
        AssertJUnit.assertTrue((boolean)lockPromise3.isAvailable());
        lockPromise3.lock();
        AssertJUnit.assertEquals((Object)"LO3", (Object)lock.getLockOwner());
        lock.release((Object)"LO3");
        AssertJUnit.assertFalse((boolean)lock.isLocked());
        lock.release((Object)"LO2");
        AssertJUnit.assertFalse((boolean)lock.isLocked());
        AssertJUnit.assertNull((Object)lock.getLockOwner());
    }

    public void testTimeout3() throws InterruptedException {
        String lockOwner1 = "LO1";
        String lockOwner2 = "LO2";
        String lockOwner3 = "LO3";
        InfinispanLock lock = new InfinispanLock((Executor)this.testExecutor(), AbstractCacheTest.TIME_SERVICE);
        ExtendedLockPromise lockPromise1 = lock.acquire((Object)"LO1", 0L, TimeUnit.MILLISECONDS);
        ExtendedLockPromise lockPromise2 = lock.acquire((Object)"LO2", 1L, TimeUnit.DAYS);
        ExtendedLockPromise lockPromise3 = lock.acquire((Object)"LO3", 1L, TimeUnit.DAYS);
        AssertJUnit.assertTrue((boolean)lockPromise1.isAvailable());
        AssertJUnit.assertFalse((boolean)lockPromise2.isAvailable());
        AssertJUnit.assertFalse((boolean)lockPromise3.isAvailable());
        lockPromise1.lock();
        AssertJUnit.assertEquals((Object)"LO1", (Object)lock.getLockOwner());
        lock.release((Object)"LO2");
        AssertJUnit.assertTrue((boolean)lock.isLocked());
        AssertJUnit.assertEquals((Object)"LO1", (Object)lock.getLockOwner());
        lock.release((Object)"LO1");
        AssertJUnit.assertTrue((boolean)lock.isLocked());
        AssertJUnit.assertTrue((boolean)lockPromise3.isAvailable());
        lockPromise3.lock();
        AssertJUnit.assertEquals((Object)"LO3", (Object)lock.getLockOwner());
        lock.release((Object)"LO3");
        AssertJUnit.assertFalse((boolean)lock.isLocked());
        lock.release((Object)"LO2");
        AssertJUnit.assertFalse((boolean)lock.isLocked());
        AssertJUnit.assertNull((Object)lock.getLockOwner());
    }

    public void testCancel() throws InterruptedException {
        InfinispanLock lock = new InfinispanLock((Executor)this.testExecutor(), AbstractCacheTest.TIME_SERVICE);
        String lockOwner1 = "LO1";
        String lockOwner2 = "LO2";
        String lockOwner3 = "LO3";
        ExtendedLockPromise lockPromise1 = lock.acquire((Object)"LO1", 0L, TimeUnit.MILLISECONDS);
        ExtendedLockPromise lockPromise2 = lock.acquire((Object)"LO2", 0L, TimeUnit.MILLISECONDS);
        ExtendedLockPromise lockPromise3 = lock.acquire((Object)"LO3", 1L, TimeUnit.DAYS);
        AssertJUnit.assertTrue((boolean)lockPromise1.isAvailable());
        AssertJUnit.assertTrue((boolean)lockPromise2.isAvailable());
        AssertJUnit.assertFalse((boolean)lockPromise3.isAvailable());
        AssertJUnit.assertEquals((Object)"LO1", (Object)lock.getLockOwner());
        lockPromise1.cancel(LockState.TIMED_OUT);
        lockPromise1.lock();
        try {
            lockPromise2.lock();
            AssertJUnit.fail((String)"TimeoutException expected");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        AssertJUnit.assertEquals((Object)"LO1", (Object)lock.getLockOwner());
        AssertJUnit.assertTrue((boolean)lockPromise2.isAvailable());
        AssertJUnit.assertFalse((boolean)lockPromise3.isAvailable());
        lockPromise2.cancel(LockState.DEADLOCKED);
        try {
            lockPromise2.lock();
            AssertJUnit.fail((String)"TimeoutException expected");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        AssertJUnit.assertEquals((Object)"LO1", (Object)lock.getLockOwner());
        AssertJUnit.assertFalse((boolean)lockPromise3.isAvailable());
        lockPromise3.cancel(LockState.DEADLOCKED);
        try {
            lockPromise3.lock();
            AssertJUnit.fail((String)"DeadlockDetectedException expected");
        }
        catch (DeadlockDetectedException deadlockDetectedException) {
            // empty catch block
        }
        lock.release((Object)"LO1");
        AssertJUnit.assertNull((Object)lock.getLockOwner());
        AssertJUnit.assertFalse((boolean)lock.isLocked());
        lockPromise1 = lock.acquire((Object)"LO1", 0L, TimeUnit.MILLISECONDS);
        lockPromise2 = lock.acquire((Object)"LO2", 1L, TimeUnit.DAYS);
        lockPromise1.lock();
        lockPromise1.cancel(LockState.TIMED_OUT);
        lockPromise1.lock();
        lockPromise2.cancel(LockState.TIMED_OUT);
        AssertJUnit.assertTrue((boolean)lockPromise2.isAvailable());
        lock.release((Object)"LO1");
        try {
            lockPromise2.lock();
            AssertJUnit.fail((String)"TimeoutException expected");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        AssertJUnit.assertNull((Object)lock.getLockOwner());
        AssertJUnit.assertFalse((boolean)lock.isLocked());
    }

    public void testSingleCounter() throws ExecutionException, InterruptedException {
        NotThreadSafeCounter counter = new NotThreadSafeCounter();
        InfinispanLock counterLock = new InfinispanLock((Executor)this.testExecutor(), AbstractCacheTest.TIME_SERVICE);
        int numThreads = 8;
        int maxCounterValue = 100;
        CyclicBarrier barrier = new CyclicBarrier(8);
        ArrayList<Future<Collection>> callableResults = new ArrayList<Future<Collection>>(8);
        for (int i = 0; i < 8; ++i) {
            callableResults.add(this.fork(() -> {
                Thread lockOwner = Thread.currentThread();
                AssertJUnit.assertEquals((int)0, (int)counter.getCount());
                LinkedList<Integer> seenValues = new LinkedList<Integer>();
                barrier.await();
                while (true) {
                    counterLock.acquire((Object)lockOwner, 1L, TimeUnit.DAYS).lock();
                    AssertJUnit.assertEquals((Object)lockOwner, (Object)counterLock.getLockOwner());
                    try {
                        int value = counter.getCount();
                        if (value == 100) {
                            LinkedList<Integer> linkedList = seenValues;
                            return linkedList;
                        }
                        seenValues.add(value);
                        counter.setCount(value + 1);
                        continue;
                    }
                    finally {
                        counterLock.release((Object)lockOwner);
                        continue;
                    }
                    break;
                }
            }));
        }
        HashSet<Integer> seenResults = new HashSet<Integer>();
        for (Future future : callableResults) {
            for (Integer integer : (Collection)future.get()) {
                AssertJUnit.assertTrue((boolean)seenResults.add(integer));
            }
        }
        AssertJUnit.assertEquals((int)100, (int)seenResults.size());
        for (int i = 0; i < 100; ++i) {
            AssertJUnit.assertTrue((boolean)seenResults.contains(i));
        }
        AssertJUnit.assertFalse((boolean)counterLock.isLocked());
    }

    public void testLockAcquiredCreation() throws InterruptedException {
        String lockOwner = "LO";
        ByRef lockPromise = ByRef.create(null);
        AtomicInteger releaseCount = new AtomicInteger();
        InfinispanLock lock = new InfinispanLock((Executor)this.testExecutor(), TIME_SERVICE, releaseCount::incrementAndGet, (Object)lockOwner, lockPromise);
        ExtendedLockPromise promise = (ExtendedLockPromise)lockPromise.get();
        AssertJUnit.assertEquals((Object)lockOwner, (Object)lock.getLockOwner());
        AssertJUnit.assertEquals((Object)lockOwner, (Object)promise.getOwner());
        AssertJUnit.assertEquals((Object)lockOwner, (Object)promise.getRequestor());
        AssertJUnit.assertTrue((boolean)lock.containsLockOwner((Object)lockOwner));
        AssertJUnit.assertEquals((Object)promise, (Object)lock.acquire((Object)lockOwner, 0L, TimeUnit.SECONDS));
        AssertJUnit.assertTrue((boolean)lock.isLocked());
        AssertJUnit.assertTrue((boolean)promise.isAvailable());
        promise.lock();
        AssertJUnit.assertTrue((boolean)promise.toInvocationStage(() -> {
            throw new IllegalStateException();
        }).isDone());
        AssertJUnit.assertTrue((boolean)promise.toInvocationStage().isDone());
        promise.addListener(state -> AssertJUnit.assertEquals((Object)LockState.ACQUIRED, (Object)state));
        AssertJUnit.assertEquals((int)0, (int)releaseCount.get());
        promise.cancel(LockState.TIMED_OUT);
        promise.addListener(state -> AssertJUnit.assertEquals((Object)LockState.ACQUIRED, (Object)state));
        AssertJUnit.assertEquals((int)0, (int)releaseCount.get());
        lock.release((Object)lockOwner);
        AssertJUnit.assertFalse((boolean)lock.isLocked());
        AssertJUnit.assertEquals((int)1, (int)releaseCount.get());
        lockOwner = "LO2";
        promise = lock.acquire((Object)lockOwner, 0L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((Object)lockOwner, (Object)lock.getLockOwner());
        AssertJUnit.assertEquals((Object)lockOwner, (Object)promise.getOwner());
        AssertJUnit.assertEquals((Object)lockOwner, (Object)promise.getRequestor());
        AssertJUnit.assertTrue((boolean)lock.containsLockOwner((Object)lockOwner));
        AssertJUnit.assertTrue((boolean)promise.isAvailable());
        promise.lock();
        lock.release((Object)lockOwner);
        AssertJUnit.assertEquals((int)2, (int)releaseCount.get());
    }

    public void testLockAcquiredCreation2() throws InterruptedException {
        String lockOwner = "LO";
        ByRef lockPromise = ByRef.create(null);
        AtomicInteger releaseCount = new AtomicInteger();
        InfinispanLock lock = new InfinispanLock((Executor)this.testExecutor(), TIME_SERVICE, releaseCount::incrementAndGet, (Object)lockOwner, lockPromise);
        ExtendedLockPromise promise = (ExtendedLockPromise)lockPromise.get();
        String lockOwner2 = "LO2";
        ExtendedLockPromise promise2 = lock.acquire((Object)lockOwner2, 1L, TimeUnit.DAYS);
        AssertJUnit.assertTrue((boolean)lock.isLocked());
        AssertJUnit.assertTrue((boolean)promise.isAvailable());
        AssertJUnit.assertFalse((boolean)promise2.isAvailable());
        promise.lock();
        lock.release((Object)lockOwner);
        AssertJUnit.assertEquals((int)1, (int)releaseCount.get());
        AssertJUnit.assertTrue((boolean)lock.isLocked());
        AssertJUnit.assertTrue((boolean)promise2.isAvailable());
        promise2.lock();
        AssertJUnit.assertEquals((Object)lockOwner2, (Object)lock.getLockOwner());
        AssertJUnit.assertEquals((Object)lockOwner2, (Object)promise2.getOwner());
        AssertJUnit.assertEquals((Object)lockOwner2, (Object)promise2.getRequestor());
        lock.release((Object)lockOwner2);
        AssertJUnit.assertFalse((boolean)lock.isLocked());
        AssertJUnit.assertEquals((int)2, (int)releaseCount.get());
    }

    private static class NotThreadSafeCounter {
        private int count;

        private NotThreadSafeCounter() {
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }
}

