/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.concurrent.Callable;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.InvalidationModePessimisticLockReleaseTest")
public class InvalidationModePessimisticLockReleaseTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = InvalidationModePessimisticLockReleaseTest.getDefaultClusteredCacheConfig(CacheMode.INVALIDATION_SYNC, true, true);
        builder.transaction().useSynchronization(false).lockingMode(LockingMode.PESSIMISTIC).locking().lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis()).useLockStriping(false);
        this.createCluster(builder, 2);
        this.waitForClusterToForm();
    }

    public void testStaleRemoteLocks() throws Exception {
        TestingUtil.withTx(this.tm(1), new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                InvalidationModePessimisticLockReleaseTest.this.cache(1).put((Object)1, (Object)"val_1");
                InvalidationModePessimisticLockReleaseTest.this.cache(1).put((Object)2, (Object)"val_2");
                return null;
            }
        });
        this.assertValue(1, 1, "val_1");
        this.assertValue(1, 2, "val_2");
        AssertJUnit.assertFalse((boolean)this.checkLocked(1, (Object)1));
        AssertJUnit.assertFalse((boolean)this.checkLocked(1, (Object)2));
        InvalidationModePessimisticLockReleaseTest.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return !InvalidationModePessimisticLockReleaseTest.this.checkLocked(0, 1) && !InvalidationModePessimisticLockReleaseTest.this.checkLocked(0, 2);
            }
        });
        this.cache(0).put((Object)1, (Object)"new_val_1");
        this.assertValue(0, 1, "new_val_1");
        this.assertValue(1, 1, null);
        this.assertValue(1, 2, "val_2");
    }

    private void assertValue(int nodeIndex, Object key, Object expectedValue) {
        AssertJUnit.assertEquals((Object)expectedValue, (Object)this.cache(nodeIndex).get(key));
    }
}

