/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.TimeoutException;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.locks.ExtendedLockPromise;
import org.infinispan.util.concurrent.locks.LockPromise;
import org.infinispan.util.concurrent.locks.impl.LockContainer;
import org.infinispan.util.concurrent.locks.impl.PerKeyLockContainer;
import org.infinispan.util.concurrent.locks.impl.StripedLockContainer;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="lock.LockContainerTest")
public class LockContainerTest
extends AbstractInfinispanTest {
    public void testSingleLockWithPerEntry() throws InterruptedException {
        PerKeyLockContainer lockContainer = new PerKeyLockContainer();
        TestingUtil.inject(lockContainer, AbstractCacheTest.TIME_SERVICE);
        this.doSingleLockTest((LockContainer)lockContainer, -1);
    }

    public void testSingleCounterTestPerEntry() throws ExecutionException, InterruptedException {
        PerKeyLockContainer lockContainer = new PerKeyLockContainer();
        TestingUtil.inject(lockContainer, AbstractCacheTest.TIME_SERVICE);
        this.doSingleCounterTest((LockContainer)lockContainer, -1);
    }

    public void testSingleLockWithStriped() throws InterruptedException {
        StripedLockContainer lockContainer = new StripedLockContainer(16);
        TestingUtil.inject(lockContainer, AbstractCacheTest.TIME_SERVICE);
        this.doSingleLockTest((LockContainer)lockContainer, 16);
    }

    public void testSingleCounterWithStriped() throws ExecutionException, InterruptedException {
        StripedLockContainer lockContainer = new StripedLockContainer(16);
        TestingUtil.inject(lockContainer, AbstractCacheTest.TIME_SERVICE);
        this.doSingleCounterTest((LockContainer)lockContainer, 16);
    }

    private void doSingleCounterTest(LockContainer lockContainer, int poolSize) throws InterruptedException, ExecutionException {
        NotThreadSafeCounter counter = new NotThreadSafeCounter();
        String key = "key";
        int numThreads = 8;
        int maxCounterValue = 100;
        CyclicBarrier barrier = new CyclicBarrier(8);
        ArrayList<Future<Collection>> callableResults = new ArrayList<Future<Collection>>(8);
        for (int i = 0; i < 8; ++i) {
            callableResults.add(this.fork(() -> {
                Thread lockOwner = Thread.currentThread();
                AssertJUnit.assertEquals((int)0, (int)counter.getCount());
                LinkedList<Integer> seenValues = new LinkedList<Integer>();
                barrier.await();
                while (true) {
                    lockContainer.acquire((Object)"key", (Object)lockOwner, 1L, TimeUnit.DAYS).lock();
                    AssertJUnit.assertEquals((Object)lockOwner, (Object)lockContainer.getLock((Object)"key").getLockOwner());
                    try {
                        int value = counter.getCount();
                        if (value == 100) {
                            LinkedList<Integer> linkedList = seenValues;
                            return linkedList;
                        }
                        seenValues.add(value);
                        counter.setCount(value + 1);
                        continue;
                    }
                    finally {
                        lockContainer.release((Object)"key", (Object)lockOwner);
                        continue;
                    }
                    break;
                }
            }));
        }
        HashSet<Integer> seenResults = new HashSet<Integer>();
        for (Future future : callableResults) {
            for (Integer integer : (Collection)future.get()) {
                AssertJUnit.assertTrue((boolean)seenResults.add(integer));
            }
        }
        AssertJUnit.assertEquals((int)100, (int)seenResults.size());
        for (int i = 0; i < 100; ++i) {
            AssertJUnit.assertTrue((boolean)seenResults.contains(i));
        }
        AssertJUnit.assertEquals((int)0, (int)lockContainer.getNumLocksHeld());
        if (poolSize == -1) {
            AssertJUnit.assertEquals((int)0, (int)lockContainer.size());
        } else {
            AssertJUnit.assertEquals((int)poolSize, (int)lockContainer.size());
        }
    }

    private void doSingleLockTest(LockContainer container, int poolSize) throws InterruptedException {
        String lockOwner1 = "LO1";
        String lockOwner2 = "LO2";
        String lockOwner3 = "LO3";
        ExtendedLockPromise lockPromise1 = container.acquire((Object)"key", (Object)"LO1", 0L, TimeUnit.MILLISECONDS);
        ExtendedLockPromise lockPromise2 = container.acquire((Object)"key", (Object)"LO2", 0L, TimeUnit.MILLISECONDS);
        ExtendedLockPromise lockPromise3 = container.acquire((Object)"key", (Object)"LO3", 0L, TimeUnit.MILLISECONDS);
        AssertJUnit.assertEquals((int)1, (int)container.getNumLocksHeld());
        if (poolSize == -1) {
            AssertJUnit.assertEquals((int)1, (int)container.size());
        } else {
            AssertJUnit.assertEquals((int)poolSize, (int)container.size());
        }
        this.acquireLock((LockPromise)lockPromise1, false);
        this.acquireLock((LockPromise)lockPromise2, true);
        this.acquireLock((LockPromise)lockPromise3, true);
        AssertJUnit.assertEquals((int)1, (int)container.getNumLocksHeld());
        if (poolSize == -1) {
            AssertJUnit.assertEquals((int)1, (int)container.size());
        } else {
            AssertJUnit.assertEquals((int)poolSize, (int)container.size());
        }
        container.release((Object)"key", (Object)"LO2");
        container.release((Object)"key", (Object)"LO3");
        AssertJUnit.assertEquals((int)1, (int)container.getNumLocksHeld());
        if (poolSize == -1) {
            AssertJUnit.assertEquals((int)1, (int)container.size());
        } else {
            AssertJUnit.assertEquals((int)poolSize, (int)container.size());
        }
        container.release((Object)"key", (Object)"LO1");
        AssertJUnit.assertEquals((int)0, (int)container.getNumLocksHeld());
        if (poolSize == -1) {
            AssertJUnit.assertEquals((int)0, (int)container.size());
        } else {
            AssertJUnit.assertEquals((int)poolSize, (int)container.size());
        }
    }

    private void acquireLock(LockPromise promise, boolean timeout) throws InterruptedException {
        try {
            promise.lock();
            AssertJUnit.assertFalse((boolean)timeout);
        }
        catch (TimeoutException e) {
            AssertJUnit.assertTrue((boolean)timeout);
        }
    }

    private static class NotThreadSafeCounter {
        private int count;

        private NotThreadSafeCounter() {
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }
}

