/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock;

import java.util.Collection;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.util.AbstractDelegatingRpcManager;

public abstract class AbstractCrashTest
extends MultipleCacheManagersTest {
    protected CacheMode cacheMode;
    protected LockingMode lockingMode;
    protected Boolean useSynchronization;

    protected AbstractCrashTest(CacheMode cacheMode, LockingMode lockingMode, Boolean useSynchronization) {
        this.cacheMode = cacheMode;
        this.lockingMode = lockingMode;
        this.useSynchronization = useSynchronization;
    }

    @Override
    protected void createCacheManagers() {
        ConfigurationBuilder c = this.buildConfiguration();
        this.createCluster(TestDataSCI.INSTANCE, c, 3);
        this.waitForClusterToForm();
    }

    protected ConfigurationBuilder buildConfiguration() {
        ConfigurationBuilder c = AbstractCrashTest.getDefaultClusteredCacheConfig(this.cacheMode, true);
        c.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).useSynchronization(this.useSynchronization.booleanValue()).lockingMode(this.lockingMode).recovery().disable().clustering().l1().disable().hash().numOwners(3).stateTransfer().fetchInMemoryState(false).locking().isolationLevel(IsolationLevel.READ_COMMITTED);
        return c;
    }

    protected Future<Void> beginAndPrepareTx(Object k, int cacheIndex) {
        return this.fork(() -> {
            try {
                this.tm(cacheIndex).begin();
                this.cache(cacheIndex).put(k, (Object)"v");
                EmbeddedTransaction transaction = (EmbeddedTransaction)this.tm(cacheIndex).getTransaction();
                transaction.runPrepare();
            }
            catch (Throwable e) {
                log.errorf(e, "Error preparing transaction for key %s on cache %s", k, this.cache(cacheIndex));
            }
        });
    }

    protected Future<Void> beginAndCommitTx(Object k, int cacheIndex) {
        return this.fork(() -> {
            try {
                this.tm(cacheIndex).begin();
                this.cache(cacheIndex).put(k, (Object)"v");
                this.tm(cacheIndex).commit();
            }
            catch (Throwable e) {
                log.errorf(e, "Error committing transaction for key %s on cache %s", k, this.cache(cacheIndex));
            }
        });
    }

    protected void skipTxCompletion(AdvancedCache<Object, Object> cache, final CountDownLatch releaseLocksLatch) {
        AbstractDelegatingRpcManager rpcManager = new AbstractDelegatingRpcManager(cache.getRpcManager()){

            @Override
            protected <T> void performSend(Collection<Address> targets, ReplicableCommand command, Function<ResponseCollector<T>, CompletionStage<T>> invoker) {
                if (command instanceof TxCompletionNotificationCommand) {
                    releaseLocksLatch.countDown();
                    log.tracef("Skipping TxCompletionNotificationCommand", new Object[0]);
                } else {
                    super.performSend(targets, command, invoker);
                }
            }
        };
        TransactionTable transactionTable = TestingUtil.getTransactionTable(this.cache(1));
        TestingUtil.replaceField(rpcManager, "rpcManager", transactionTable, TransactionTable.class);
        TxControlInterceptor txControlInterceptor = new TxControlInterceptor();
        txControlInterceptor.prepareProgress.countDown();
        txControlInterceptor.commitProgress.countDown();
        TestingUtil.extractInterceptorChain(this.advancedCache(1)).addInterceptor((AsyncInterceptor)txControlInterceptor, 1);
    }

    public static class TxControlInterceptor
    extends DDAsyncInterceptor {
        public CountDownLatch prepareProgress = new CountDownLatch(1);
        public CountDownLatch preparedReceived = new CountDownLatch(1);
        public CountDownLatch commitReceived = new CountDownLatch(1);
        public CountDownLatch commitProgress = new CountDownLatch(1);

        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            return this.invokeNextAndFinally((InvocationContext)ctx, (VisitableCommand)command, (rCtx, rCommand, rv, throwable) -> {
                this.preparedReceived.countDown();
                this.prepareProgress.await();
            });
        }

        public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
            this.commitReceived.countDown();
            this.commitProgress.await();
            return this.invokeNext((InvocationContext)ctx, (VisitableCommand)command);
        }
    }
}

