/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock;

import jakarta.transaction.Transaction;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.MinViewIdCalculusTest")
@CleanupAfterMethod
public class MinViewIdCalculusTest
extends MultipleCacheManagersTest {
    private ConfigurationBuilder c;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.c = MinViewIdCalculusTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        this.c.transaction().lockingMode(LockingMode.PESSIMISTIC).transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).clustering().hash().numOwners(3);
        this.createCluster(TestDataSCI.INSTANCE, this.c, 2);
        this.waitForClusterToForm();
    }

    private void createNewNode() {
        log.trace((Object)"Adding new node ..");
        this.addClusterEnabledCacheManager(TestDataSCI.INSTANCE, this.c);
        this.waitForClusterToForm();
        log.trace((Object)"New node added.");
    }

    public void testMinViewId1() throws Exception {
        TransactionTable tt0 = TestingUtil.getTransactionTable(this.cache(0));
        TransactionTable tt1 = TestingUtil.getTransactionTable(this.cache(1));
        DistributionManager distributionManager0 = this.advancedCache(0).getDistributionManager();
        int topologyId = distributionManager0.getCacheTopology().getTopologyId();
        Assert.assertEquals((int)tt0.getMinTopologyId(), (int)topologyId);
        Assert.assertEquals((int)tt1.getMinTopologyId(), (int)topologyId);
        this.createNewNode();
        int topologyId2 = distributionManager0.getCacheTopology().getTopologyId();
        Assert.assertTrue((topologyId2 > topologyId ? 1 : 0) != 0);
        TransactionTable tt2 = TestingUtil.getTransactionTable(this.cache(2));
        MinViewIdCalculusTest.eventually(() -> tt0.getMinTopologyId() == topologyId2 && tt1.getMinTopologyId() == topologyId2 && tt2.getMinTopologyId() == topologyId2);
    }

    public void testMinViewId2() throws Exception {
        TransactionTable tt0 = TestingUtil.getTransactionTable(this.cache(0));
        TransactionTable tt1 = TestingUtil.getTransactionTable(this.cache(1));
        DistributionManager distributionManager0 = this.advancedCache(0).getDistributionManager();
        int topologyId = distributionManager0.getCacheTopology().getTopologyId();
        this.tm(1).begin();
        this.cache(1).put(this.getKeyForCache(0), (Object)"v");
        EmbeddedTransaction t = (EmbeddedTransaction)this.tm(1).getTransaction();
        t.runPrepare();
        this.tm(1).suspend();
        MinViewIdCalculusTest.eventually(() -> this.checkTxCount(0, 0, 1));
        this.createNewNode();
        int topologyId2 = distributionManager0.getCacheTopology().getTopologyId();
        Assert.assertTrue((topologyId2 > topologyId ? 1 : 0) != 0);
        Assert.assertEquals((int)tt0.getMinTopologyId(), (int)topologyId);
        Assert.assertEquals((int)tt1.getMinTopologyId(), (int)topologyId);
        this.tm(1).resume((Transaction)t);
        t.runCommit(false);
        MinViewIdCalculusTest.eventually(() -> tt0.getMinTopologyId() == topologyId2 && tt1.getMinTopologyId() == topologyId2);
    }
}

