/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.manager.CacheManagerAdminTest;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.annotations.Test;

@Test(testName="manager.CacheManagerAdminPermanentTest", groups={"functional"})
@CleanupAfterMethod
public class CacheManagerAdminPermanentTest
extends CacheManagerAdminTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Util.recursiveFileRemove((String)CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName()}));
        this.createStatefulCacheManager("A", false);
        this.createStatefulCacheManager("B", false);
    }

    protected boolean isShared() {
        return false;
    }

    protected void createStatefulCacheManager(String id, boolean clear) {
        String stateDirectory = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), id});
        if (clear) {
            Util.recursiveFileRemove((String)stateDirectory);
        }
        GlobalConfigurationBuilder global = GlobalConfigurationBuilder.defaultClusteredBuilder();
        global.globalState().enable().persistentLocation(stateDirectory).configurationStorage(ConfigurationStorage.OVERLAY);
        if (this.isShared()) {
            String sharedDirectory = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), "COMMON"});
            global.globalState().sharedPersistentLocation(sharedDirectory);
        } else {
            global.globalState().sharedPersistentLocation(stateDirectory);
        }
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        this.addClusterEnabledCacheManager(global, builder);
    }

    @Override
    public void testClusterCacheTest() {
        this.waitForClusterToForm();
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        Configuration configuration = builder.build();
        this.manager(0).administration().createCache("a", configuration);
        this.waitForClusterToForm("a");
        this.checkConsistencyAcrossCluster("a", configuration);
        ((EmbeddedCacheManagerAdmin)this.manager(1).administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE})).createCache("b", configuration);
        TestingUtil.killCacheManagers(this.cacheManagers);
        this.cacheManagers.clear();
        this.createStatefulCacheManager("A", false);
        this.checkConsistencyAcrossCluster("a", configuration);
        this.createStatefulCacheManager("B", true);
        this.checkConsistencyAcrossCluster("a", configuration);
        this.checkCacheExistenceAcrossCluster("b", false);
        this.manager(0).administration().createCache("c", configuration);
        this.checkConsistencyAcrossCluster("c", configuration);
        this.createStatefulCacheManager("C", false);
        this.checkConsistencyAcrossCluster("a", configuration);
    }
}

