/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.security.auth.Subject;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.Security;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.GenericTransactionManagerLookup;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="manager.CacheManagerXmlConfigurationTest")
public class CacheManagerXmlConfigurationTest
extends AbstractInfinispanTest {
    EmbeddedCacheManager cm;
    private final Subject KING = TestingUtil.makeSubject("king-arthur", "king");

    @AfterMethod
    public void tearDown() {
        if (this.cm != null) {
            Security.doAs((Subject)this.KING, () -> this.cm.stop());
        }
        this.cm = null;
    }

    public void testNamedCacheXML() throws IOException {
        this.cm = TestCacheManagerFactory.fromXml("configs/named-cache-test.xml", false, false, new TransportFlags());
        GlobalConfiguration globalConfiguration = TestingUtil.extractGlobalConfiguration(this.cm);
        AssertJUnit.assertEquals((String)"s1", (String)globalConfiguration.transport().siteId());
        AssertJUnit.assertEquals((String)"r1", (String)globalConfiguration.transport().rackId());
        AssertJUnit.assertEquals((String)"m1", (String)globalConfiguration.transport().machineId());
        AssertJUnit.assertNotNull((Object)globalConfiguration.transport().transport());
        Configuration c = this.getDefaultCacheConfiguration();
        AssertJUnit.assertEquals((int)100, (int)c.locking().concurrencyLevel());
        AssertJUnit.assertEquals((long)1000L, (long)c.locking().lockAcquisitionTimeout());
        AssertJUnit.assertFalse((boolean)c.transaction().transactionMode().isTransactional());
        AssertJUnit.assertEquals((Object)TransactionMode.NON_TRANSACTIONAL, (Object)c.transaction().transactionMode());
        c = this.getCacheConfiguration(this.cm, "transactional");
        AssertJUnit.assertTrue((boolean)c.transaction().transactionMode().isTransactional());
        AssertJUnit.assertEquals((int)32, (int)c.locking().concurrencyLevel());
        AssertJUnit.assertEquals((long)10000L, (long)c.locking().lockAcquisitionTimeout());
        AssertJUnit.assertTrue((boolean)(c.transaction().transactionManagerLookup() instanceof GenericTransactionManagerLookup));
        c = this.getCacheConfiguration(this.cm, "syncRepl");
        AssertJUnit.assertEquals((int)32, (int)c.locking().concurrencyLevel());
        AssertJUnit.assertEquals((long)10000L, (long)c.locking().lockAcquisitionTimeout());
        AssertJUnit.assertEquals((Object)TransactionMode.NON_TRANSACTIONAL, (Object)c.transaction().transactionMode());
        c = this.getCacheConfiguration(this.cm, "txSyncRepl");
        AssertJUnit.assertEquals((int)32, (int)c.locking().concurrencyLevel());
        AssertJUnit.assertEquals((long)10000L, (long)c.locking().lockAcquisitionTimeout());
        AssertJUnit.assertTrue((boolean)(c.transaction().transactionManagerLookup() instanceof GenericTransactionManagerLookup));
    }

    private Configuration getCacheConfiguration(EmbeddedCacheManager cm, String cacheName) {
        return (Configuration)Security.doAs((Subject)this.KING, () -> cm.getCacheConfiguration(cacheName));
    }

    private Configuration getDefaultCacheConfiguration() {
        return (Configuration)Security.doAs((Subject)this.KING, () -> this.cm.getDefaultCacheConfiguration());
    }

    public void testNamedCacheXMLClashingNames() {
        String xml = TestingUtil.wrapXMLWithSchema("<cache-container default-cache=\"default\">\n   <local-cache name=\"default\">\n        <locking concurrencyLevel=\"100\" lockAcquisitionTimeout=\"1000\" />\n   </local-cache>\n\n   <local-cache name=\"c1\">\n        <transaction transaction-manager-lookup=\"org.infinispan.transaction.lookup.GenericTransactionManagerLookup\"/>\n   </local-cache>\n\n   <replicated-cache name=\"c1\" mode=\"SYNC\" remote-timeout=\"15000\">\n   </replicated-cache>\n</cache-container>");
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
        try {
            this.cm = TestCacheManagerFactory.fromStream(bais);
            assert (false) : "Should fail";
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBatchingIsEnabled() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.fromXml("configs/batching.xml");
        try {
            Configuration c = cm.getCacheConfiguration("default");
            AssertJUnit.assertTrue((boolean)c.invocationBatching().enabled());
            AssertJUnit.assertTrue((boolean)c.transaction().transactionMode().isTransactional());
            c = cm.getDefaultCacheConfiguration();
            AssertJUnit.assertTrue((boolean)c.invocationBatching().enabled());
            Configuration c2 = cm.getCacheConfiguration("tml");
            AssertJUnit.assertTrue((boolean)c2.transaction().transactionMode().isTransactional());
        }
        finally {
            cm.stop();
        }
    }

    public void testXInclude() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.fromXml("configs/include.xml");
        try {
            AssertJUnit.assertEquals((String)"included", (String)((String)cm.getCacheManagerConfiguration().defaultCacheName().get()));
            AssertJUnit.assertNotNull((Object)cm.getCacheConfiguration("included"));
            AssertJUnit.assertEquals((Object)CacheMode.LOCAL, (Object)cm.getCacheConfiguration("included").clustering().cacheMode());
            AssertJUnit.assertEquals((Object)CacheMode.LOCAL, (Object)cm.getCacheConfiguration("another-included").clustering().cacheMode());
        }
        finally {
            cm.stop();
        }
    }
}

