/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.util.ArrayList;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="manager.ConcurrentCacheManagerTest")
public class ConcurrentCacheManagerTest
extends AbstractCacheTest {
    private static final int NUM_CACHES = 4;
    private static final int NUM_THREADS = 25;
    private EmbeddedCacheManager cacheManager;

    @BeforeMethod
    protected void setup() throws Exception {
        EmbeddedCacheManager manager = TestCacheManagerFactory.createCacheManager();
        for (int i = 0; i < 4; ++i) {
            manager.defineConfiguration("cache" + i, TestCacheManagerFactory.getDefaultCacheConfiguration(false).build());
        }
        this.cacheManager = manager;
    }

    @AfterMethod
    protected void teardown() {
        TestingUtil.killCacheManagers(this.cacheManager);
    }

    public void testConcurrentGetCacheCalls() throws Exception {
        CyclicBarrier barrier = new CyclicBarrier(26);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(25);
        ExecutorService executorService = Executors.newFixedThreadPool(25, this.getTestThreadFactory("Worker"));
        for (int i = 0; i < 25; ++i) {
            log.debug((Object)"Schedule execution");
            String string = "cache" + i % 4;
            Future<Void> future = executorService.submit(() -> {
                try {
                    barrier.await();
                    log.tracef("Creating cache %s", (Object)name);
                    Cache cache = this.cacheManager.getCache(name);
                    cache.put((Object)"a", (Object)"b");
                    Void void_ = null;
                    return void_;
                }
                catch (Throwable t) {
                    log.error((Object)"Got", t);
                    throw new RuntimeException(t);
                }
                finally {
                    log.debug((Object)"Wait for all execution paths to finish");
                    barrier.await();
                }
            });
            futures.add(future);
        }
        barrier.await();
        barrier.await();
        log.debug((Object)"All threads finished, let's shutdown the executor and check whether any exceptions were reported");
        for (Future future : futures) {
            future.get();
        }
        executorService.shutdownNow();
    }
}

