/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.infinispan.Cache;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.BufferSizePredictor;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.marshall.persistence.impl.PersistenceMarshallerImpl;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class TestObjectStreamMarshaller
implements PersistenceMarshaller {
    private static final Log log = LogFactory.getLog(TestObjectStreamMarshaller.class);
    private final PersistenceMarshallerImpl marshaller;
    public final EmbeddedCacheManager cacheManager;

    public TestObjectStreamMarshaller() {
        this(null);
    }

    public TestObjectStreamMarshaller(SerializationContextInitializer sci) {
        this.cacheManager = TestCacheManagerFactory.createCacheManager(sci, new ConfigurationBuilder());
        this.marshaller = (PersistenceMarshallerImpl)ComponentRegistry.of((Cache)this.cacheManager.getCache()).getPersistenceMarshaller();
    }

    public ClassAllowList getAllowList() {
        return this.cacheManager.getClassAllowList();
    }

    public byte[] objectToByteBuffer(Object obj, int estimatedSize) throws IOException, InterruptedException {
        return this.marshaller.objectToByteBuffer(obj, estimatedSize);
    }

    public byte[] objectToByteBuffer(Object obj) throws IOException, InterruptedException {
        return this.marshaller.objectToByteBuffer(obj);
    }

    public Object objectFromByteBuffer(byte[] buf) throws IOException, ClassNotFoundException {
        return this.marshaller.objectFromByteBuffer(buf);
    }

    public ByteBuffer objectToBuffer(Object o) throws IOException, InterruptedException {
        return this.marshaller.objectToBuffer(o);
    }

    public BufferSizePredictor getBufferSizePredictor(Object o) {
        return this.marshaller.getBufferSizePredictor(o);
    }

    public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException, ClassNotFoundException {
        return this.marshaller.objectFromByteBuffer(buf, offset, length);
    }

    public void writeObject(Object o, OutputStream out) throws IOException {
        this.marshaller.writeObject(o, out);
    }

    public Object readObject(InputStream in) throws ClassNotFoundException, IOException {
        return this.marshaller.readObject(in);
    }

    public boolean isMarshallable(Object o) {
        return this.marshaller.isMarshallable(o);
    }

    @Stop
    public void stop() {
        log.trace((Object)"TestObjectStreamMarshaller.stop()");
        TestingUtil.killCacheManagers(this.cacheManager);
    }

    public void start() {
    }

    public MediaType mediaType() {
        return this.marshaller.mediaType();
    }

    public void register(SerializationContextInitializer initializer) {
        this.marshaller.register(initializer);
    }

    public Marshaller getUserMarshaller() {
        return this.marshaller.getUserMarshaller();
    }

    public int sizeEstimate(Object o) {
        return this.marshaller.sizeEstimate(o);
    }
}

