/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.cachelistener.CacheNotifierInvalidationTest")
public class CacheNotifierInvalidationTest
extends MultipleCacheManagersTest {
    protected final String CACHE_NAME = "testCache";
    protected ConfigurationBuilder builderUsed;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.builderUsed = new ConfigurationBuilder();
        this.builderUsed.clustering().cacheMode(CacheMode.INVALIDATION_SYNC);
        this.createClusteredCaches(3, "testCache", this.builderUsed);
    }

    @Test
    public void testRemoteNodeValueInvalidated() {
        String key = "key";
        String value = "value";
        Cache cache0 = this.cache(0, "testCache");
        cache0.put((Object)key, (Object)value);
        AllCacheEntryListener listener = new AllCacheEntryListener();
        cache0.addListener((Object)listener);
        String value2 = "value2";
        this.cache(1, "testCache").put((Object)key, (Object)value2);
        AssertJUnit.assertEquals((int)2, (int)listener.events.size());
        CacheEntryEvent event = listener.events.get(0);
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_INVALIDATED, (Object)event.getType());
        AssertJUnit.assertEquals((Object)key, (Object)event.getKey());
        AssertJUnit.assertEquals((Object)value, (Object)event.getValue());
        AssertJUnit.assertTrue((boolean)event.isPre());
        AssertJUnit.assertFalse((boolean)event.isOriginLocal());
        event = listener.events.get(1);
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_INVALIDATED, (Object)event.getType());
        AssertJUnit.assertEquals((Object)key, (Object)event.getKey());
        AssertJUnit.assertEquals((Object)value, (Object)event.getValue());
        AssertJUnit.assertFalse((boolean)event.isPre());
        AssertJUnit.assertFalse((boolean)event.isOriginLocal());
    }

    @Listener
    private static class AllCacheEntryListener {
        private final List<CacheEntryEvent> events = Collections.synchronizedList(new ArrayList());

        private AllCacheEntryListener() {
        }

        @CacheEntryVisited
        @CacheEntryActivated
        @CacheEntryModified
        @CacheEntryRemoved
        @CacheEntryCreated
        @CacheEntryInvalidated
        @CacheEntryPassivated
        public void listenEvent(CacheEntryEvent event) {
            this.events.add(event);
        }
    }
}

