/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.util.LinkedList;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.cachelistener.DuplicatedEventsTest")
public class DuplicatedEventsTest
extends MultipleCacheManagersTest {
    public void testNonDuplicate() {
        Cache cacheA = this.cache(0);
        Cache cacheB = this.cache(1);
        MyCacheListener listenerA = new MyCacheListener();
        cacheA.addListener((Object)listenerA);
        MyCacheListener listenerB = new MyCacheListener();
        cacheB.addListener((Object)listenerB);
        cacheA.put((Object)"a", (Object)"a");
        AssertJUnit.assertEquals((int)2, (int)listenerA.events.size());
        AssertJUnit.assertEquals((int)2, (int)listenerB.events.size());
        this.checkEvents(listenerA, "a");
        this.checkEvents(listenerB, "a");
        listenerA.events.clear();
        listenerB.events.clear();
        cacheA.put((Object)"b", (Object)"b");
        AssertJUnit.assertEquals((int)2, (int)listenerA.events.size());
        AssertJUnit.assertEquals((int)2, (int)listenerB.events.size());
        this.checkEvents(listenerA, "b");
        this.checkEvents(listenerB, "b");
        listenerA.events.clear();
        listenerB.events.clear();
        cacheA.put((Object)"a0", (Object)"a0");
        AssertJUnit.assertEquals((int)2, (int)listenerA.events.size());
        AssertJUnit.assertEquals((int)2, (int)listenerB.events.size());
        this.checkEvents(listenerA, "a0");
        this.checkEvents(listenerB, "a0");
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = DuplicatedEventsTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
        builder.clustering().hash().numSegments(60);
        this.createClusteredCaches(2, builder);
    }

    private void checkEvents(MyCacheListener listener, String expectedKey) {
        AssertJUnit.assertTrue((boolean)(listener.events.get(0) instanceof CacheEntryCreatedEvent));
        AssertJUnit.assertEquals((String)expectedKey, (String)((String)listener.events.get(0).getKey()));
        AssertJUnit.assertTrue((boolean)listener.events.get(0).isPre());
        AssertJUnit.assertTrue((boolean)(listener.events.get(1) instanceof CacheEntryCreatedEvent));
        AssertJUnit.assertEquals((String)expectedKey, (String)((String)listener.events.get(1).getKey()));
        AssertJUnit.assertFalse((boolean)listener.events.get(1).isPre());
    }

    @Listener
    public static class MyCacheListener {
        private final List<CacheEntryEvent<String, String>> events = new LinkedList<CacheEntryEvent<String, String>>();

        @CacheEntryCreated
        public void created(CacheEntryCreatedEvent<String, String> event) {
            this.events.add((CacheEntryEvent<String, String>)event);
        }

        @CacheEntryModified
        public void modified(CacheEntryModifiedEvent<String, String> event) {
            this.events.add((CacheEntryEvent<String, String>)event);
        }

        @CacheEntryRemoved
        public void removed(CacheEntryRemovedEvent<String, String> event) {
            this.events.add((CacheEntryEvent<String, String>)event);
        }
    }
}

