/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.BlockingInterceptor;
import org.infinispan.distribution.MagicKey;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.notifications.cachelistener.cluster.AbstractClusterListenerNonTxTest;
import org.infinispan.notifications.cachelistener.cluster.AbstractClusterListenerUtilTest;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ControlledRpcManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.cachelistener.cluster.ClusterListenerReplTest")
public class ClusterListenerReplTest
extends AbstractClusterListenerNonTxTest {
    public ClusterListenerReplTest() {
        super(false, CacheMode.REPL_SYNC);
    }

    public void testPrimaryOwnerGoesDownBeforeBackupRaisesEvent() throws InterruptedException, TimeoutException, ExecutionException {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        Cache cache2 = this.cache(2, "cluster-listener");
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = new AbstractClusterListenerUtilTest.ClusterListener();
        cache0.addListener((Object)clusterListener);
        ControlledRpcManager controlledRpcManager = ControlledRpcManager.replaceRpcManager(cache1, new Class[0]);
        MagicKey key = new MagicKey(cache1, cache2);
        Future<String> future = this.fork(() -> (String)cache0.put((Object)key, (Object)"first-value"));
        ControlledRpcManager.BlockedRequest<PutKeyValueCommand> blockedPut = controlledRpcManager.expectCommand(PutKeyValueCommand.class);
        blockedPut.skipSend();
        TestingUtil.killCacheManagers(cache1.getCacheManager());
        String returnValue = future.get(10L, TimeUnit.SECONDS);
        AssertJUnit.assertTrue((returnValue == null || returnValue.equals("first-value") ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!clusterListener.events.isEmpty() ? 1 : 0) != 0);
        AssertJUnit.assertTrue((clusterListener.events.size() <= 4 ? 1 : 0) != 0);
        CacheEntryEvent firstEvent = clusterListener.events.remove(0);
        this.checkEvent((CacheEntryEvent<Object, String>)firstEvent, key, true, true);
        for (CacheEntryEvent event : clusterListener.events) {
            this.checkEvent((CacheEntryEvent<Object, String>)event, key, event.getType() == Event.Type.CACHE_ENTRY_CREATED, true);
        }
    }

    public void testPrimaryOwnerGoesDownAfterBackupRaisesEvent() throws InterruptedException, TimeoutException, ExecutionException, BrokenBarrierException {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        Cache cache2 = this.cache(2, "cluster-listener");
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = new AbstractClusterListenerUtilTest.ClusterListener();
        cache0.addListener((Object)clusterListener);
        CyclicBarrier barrier = new CyclicBarrier(3);
        BlockingInterceptor<PutKeyValueCommand> blockingInterceptor0 = new BlockingInterceptor<PutKeyValueCommand>(barrier, PutKeyValueCommand.class, true, false);
        TestingUtil.extractInterceptorChain(cache0).addInterceptorBefore(blockingInterceptor0, EntryWrappingInterceptor.class);
        BlockingInterceptor<PutKeyValueCommand> blockingInterceptor2 = new BlockingInterceptor<PutKeyValueCommand>(barrier, PutKeyValueCommand.class, true, false);
        TestingUtil.extractInterceptorChain(cache2).addInterceptorBefore(blockingInterceptor2, EntryWrappingInterceptor.class);
        MagicKey key = new MagicKey(cache1);
        Future<String> future = this.fork(() -> (String)cache0.put((Object)key, (Object)"first-value"));
        barrier.await(10L, TimeUnit.SECONDS);
        TestingUtil.extractInterceptorChain(cache0).removeInterceptor(BlockingInterceptor.class);
        TestingUtil.extractInterceptorChain(cache2).removeInterceptor(BlockingInterceptor.class);
        blockingInterceptor0.suspend(true);
        blockingInterceptor2.suspend(true);
        TestingUtil.killCacheManagers(cache1.getCacheManager());
        barrier.await(10L, TimeUnit.SECONDS);
        String returnValue = future.get(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((String)"first-value", (String)returnValue);
        AssertJUnit.assertTrue((clusterListener.events.size() >= 2 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((clusterListener.events.size() <= 4 ? 1 : 0) != 0);
        this.checkEvent((CacheEntryEvent<Object, String>)clusterListener.events.get(0), key, true, false);
        for (int i = 1; i < clusterListener.events.size(); ++i) {
            CacheEntryEvent event = clusterListener.events.get(i);
            this.checkEvent((CacheEntryEvent<Object, String>)event, key, false, true);
        }
        this.checkEvent((CacheEntryEvent<Object, String>)clusterListener.events.get(1), key, false, true);
    }
}

