/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachemanagerlistener;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="notifications.cachemanagerlistener.CacheManagerNotifierTest")
public class CacheManagerNotifierTest
extends AbstractInfinispanTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testViewChange() throws Exception {
        EmbeddedCacheManager cmA = TestCacheManagerFactory.createClusteredCacheManager();
        EmbeddedCacheManager cmB = null;
        try {
            cmA.getCache();
            GetCacheManagerCheckListener listener = new GetCacheManagerCheckListener();
            cmA.addListener((Object)listener);
            cmB = TestCacheManagerFactory.createClusteredCacheManager();
            cmB.getCache();
            AssertJUnit.assertNotNull((Object)listener.firstEvent.get(10L, TimeUnit.SECONDS));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(new CacheContainer[]{cmA, cmB});
            throw throwable;
        }
        TestingUtil.killCacheManagers(new CacheContainer[]{cmA, cmB});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddRemoveListenerWhileNotRunning() throws Exception {
        GetCacheManagerCheckListener listener = new GetCacheManagerCheckListener();
        ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder();
        holder.getGlobalConfigurationBuilder().clusteredDefault().defaultCacheName("default");
        holder.newConfigurationBuilder("default").clustering().cacheMode(CacheMode.DIST_SYNC);
        EmbeddedCacheManager cmA = TestCacheManagerFactory.createClusteredCacheManager(false, holder);
        EmbeddedCacheManager cmB = null;
        try {
            cmA.addListener((Object)listener);
            cmA.getCache();
            cmB = TestCacheManagerFactory.createClusteredCacheManager();
            cmB.getCache();
            AssertJUnit.assertNotNull((Object)listener.firstEvent.get(10L, TimeUnit.SECONDS));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cmA, cmB);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cmA, cmB);
        cmA.removeListener((Object)listener);
    }

    @Listener
    public static class GetCacheManagerCheckListener {
        CompletableFuture<ViewChangedEvent> firstEvent = new CompletableFuture();

        @ViewChanged
        public void onViewChange(ViewChangedEvent e) {
            this.firstEvent.complete(e);
        }
    }
}

