/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.BasePartitionHandlingTest;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.topology.LocalTopologyManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="partitionhandling.DegradedJoinTest")
public class DegradedJoinTest
extends BasePartitionHandlingTest {
    @Override
    public Object[] factory() {
        return new Object[]{new DegradedJoinTest().cacheMode(CacheMode.REPL_SYNC), new DegradedJoinTest().cacheMode(CacheMode.DIST_SYNC)};
    }

    public DegradedJoinTest() {
        this.numMembersInCluster = 2;
    }

    public void testSplitAndJoin() throws Exception {
        HashSet<Address> allMembers = new HashSet<Address>(Arrays.asList(this.address(0), this.address(1)));
        this.assertStableTopologyMembers(allMembers, this.partitionHandlingManager(0));
        this.assertStableTopologyMembers(allMembers, this.partitionHandlingManager(1));
        for (int i = 0; i < this.numMembersInCluster; ++i) {
            AssertJUnit.assertEquals((Object)AvailabilityMode.AVAILABLE, (Object)this.partitionHandlingManager(i).getAvailabilityMode());
        }
        BasePartitionHandlingTest.PartitionDescriptor p0 = new BasePartitionHandlingTest.PartitionDescriptor(0);
        BasePartitionHandlingTest.PartitionDescriptor p1 = new BasePartitionHandlingTest.PartitionDescriptor(1);
        this.splitCluster(p0.getNodes(), p1.getNodes());
        this.partition(0).assertDegradedMode();
        this.partition(1).assertDegradedMode();
        this.assertStableTopologyMembers(allMembers, this.partitionHandlingManager(p1.node(0)));
        this.manager(1).stop();
        this.enableDiscovery();
        ConfigurationBuilder dcc = this.cacheConfiguration();
        dcc.clustering().cacheMode(this.cacheMode).partitionHandling().whenSplit(this.partitionHandling).mergePolicy(this.mergePolicy);
        if (this.cacheMode == CacheMode.DIST_SYNC) {
            dcc.clustering().hash().numOwners(this.numberOfOwners);
        }
        GlobalConfigurationBuilder globalBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        globalBuilder.serialization().addContextInitializer(this.serializationContextInitializer());
        this.addClusterEnabledCacheManager(globalBuilder, dcc, new TransportFlags().withFD(true).withMerge(true));
        for (EmbeddedCacheManager manager : Arrays.asList(this.manager(0), this.manager(2))) {
            AdvancedCache cache = manager.getCache().getAdvancedCache();
            LocalizedCacheTopology cacheTopology = cache.getDistributionManager().getCacheTopology();
            AssertJUnit.assertEquals(Collections.singletonList(this.address(0)), (Object)cacheTopology.getActualMembers());
            AssertJUnit.assertEquals(Arrays.asList(this.address(0), this.address(1)), (Object)cacheTopology.getMembers());
            PartitionHandlingManager partitionHandlingManager = TestingUtil.extractComponent(cache, PartitionHandlingManager.class);
            AssertJUnit.assertEquals((Object)AvailabilityMode.DEGRADED_MODE, (Object)partitionHandlingManager.getAvailabilityMode());
            this.assertStableTopologyMembers(allMembers, partitionHandlingManager);
        }
        LocalTopologyManager localTopologyManager = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(0), LocalTopologyManager.class);
        localTopologyManager.setCacheAvailability(this.getDefaultCacheName(), AvailabilityMode.AVAILABLE);
        TestingUtil.waitForNoRebalance(this.cache(0), this.cache(2));
    }

    private void assertStableTopologyMembers(HashSet<Address> allMembers, PartitionHandlingManager phm) {
        AssertJUnit.assertEquals(allMembers, new HashSet(phm.getLastStableTopology().getMembers()));
    }
}

