/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.BasePartitionHandlingTest;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="partitionhandling.IndependentClustersMergeTest")
public class IndependentClustersMergeTest
extends BasePartitionHandlingTest {
    private static final String MERGE_RESULT = "merge-result";

    @Override
    public Object[] factory() {
        return new Object[]{new IndependentClustersMergeTest().partitionHandling(PartitionHandling.ALLOW_READS), new IndependentClustersMergeTest().partitionHandling(PartitionHandling.DENY_READ_WRITES)};
    }

    public IndependentClustersMergeTest() {
        this.numMembersInCluster = 2;
        this.mergePolicy = (preferredEntry, otherEntries) -> {
            CacheEntry entry = preferredEntry != null ? preferredEntry : (CacheEntry)otherEntries.get(0);
            entry.setValue((Object)MERGE_RESULT);
            return entry;
        };
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = this.cacheConfiguration();
        dcc.clustering().cacheMode(this.cacheMode).partitionHandling().whenSplit(this.partitionHandling).mergePolicy(this.mergePolicy).hash().numOwners(this.numberOfOwners);
        for (int i = 0; i < this.numMembersInCluster; ++i) {
            EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(dcc, new TransportFlags().withFD(true).withMerge(true));
            Cache cache = cm.getCache();
            this.disableDiscoveryProtocol(this.channel(cache));
        }
    }

    public void testConflictResolutionCalled() {
        Cache c0 = this.cache(0);
        Cache c1 = this.cache(1);
        AssertJUnit.assertEquals((int)1, (int)this.topologySize(c0));
        AssertJUnit.assertEquals((int)1, (int)this.topologySize(c1));
        c0.put((Object)1, (Object)1);
        c1.put((Object)1, (Object)2);
        this.enableDiscoveryProtocol(this.channel(c0));
        this.enableDiscoveryProtocol(this.channel(c1));
        TestingUtil.waitForNoRebalance(c0, c1);
        AssertJUnit.assertEquals((Object)MERGE_RESULT, (Object)c0.get((Object)1));
    }

    private int topologySize(Cache cache) {
        return cache.getAdvancedCache().getDistributionManager().getCacheTopology().getMembers().size();
    }
}

