/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.eviction.EvictionType;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.support.DelegatingPersistenceManager;
import org.infinispan.persistence.support.WaitDelegatingNonBlockingStore;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.Mocks;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.data.Address;
import org.infinispan.test.data.Person;
import org.infinispan.test.data.Sex;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.mockito.ArgumentMatchers;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit", "smoke"}, testName="persistence.BaseStoreFunctionalTest")
public abstract class BaseStoreFunctionalTest
extends SingleCacheManagerTest {
    private static final SerializationContextInitializer CONTEXT_INITIALIZER = TestDataSCI.INSTANCE;
    protected final ControlledTimeService timeService = new ControlledTimeService();

    protected abstract PersistenceConfigurationBuilder createCacheStoreConfig(PersistenceConfigurationBuilder var1, String var2, boolean var3);

    protected ConfigurationBuilder getDefaultCacheConfiguration() {
        return TestCacheManagerFactory.getDefaultCacheConfiguration(false);
    }

    protected Object wrap(String key, String value) {
        return value;
    }

    protected String unwrap(Object wrapped) {
        return (String)wrapped;
    }

    protected BaseStoreFunctionalTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.globalState().persistentLocation(CommonsTestingUtil.tmpDirectory(this.getClass()));
        global.serialization().addContextInitializer(this.getSerializationContextInitializer());
        global.cacheContainer().security().authorization().enable();
        return this.createCacheManager(false, global, new ConfigurationBuilder());
    }

    protected EmbeddedCacheManager createCacheManager(boolean start, GlobalConfigurationBuilder global, ConfigurationBuilder cb) {
        return TestCacheManagerFactory.newDefaultCacheManager(start, global, cb);
    }

    protected SerializationContextInitializer getSerializationContextInitializer() {
        return CONTEXT_INITIALIZER;
    }

    protected void assertPersonEqual(Person firstPerson, Person secondPerson) {
        AssertJUnit.assertEquals((Object)firstPerson, (Object)secondPerson);
    }

    public void testTwoCachesSameCacheStore() {
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        this.createCacheStoreConfig(cb.persistence(), "testTwoCachesSameCacheStore", false);
        Configuration c = cb.build();
        TestingUtil.defineConfiguration(this.cacheManager, "testTwoCachesSameCacheStore-1", c);
        TestingUtil.defineConfiguration(this.cacheManager, "testTwoCachesSameCacheStore-2", c);
        Cache first = this.cacheManager.getCache("testTwoCachesSameCacheStore-1");
        Cache second = this.cacheManager.getCache("testTwoCachesSameCacheStore-2");
        first.start();
        second.start();
        first.put((Object)"key", this.wrap("key", "val"));
        AssertJUnit.assertEquals((String)"val", (String)this.unwrap(first.get((Object)"key")));
        AssertJUnit.assertNull((Object)second.get((Object)"key"));
        second.put((Object)"key2", this.wrap("key2", "val2"));
        AssertJUnit.assertEquals((String)"val2", (String)this.unwrap(second.get((Object)"key2")));
        AssertJUnit.assertNull((Object)first.get((Object)"key2"));
    }

    public void testPreloadAndExpiry() {
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        this.createCacheStoreConfig(cb.persistence(), "testPreloadAndExpiry", true);
        TestingUtil.defineConfiguration(this.cacheManager, "testPreloadAndExpiry", cb.build());
        Cache cache = this.cacheManager.getCache("testPreloadAndExpiry");
        cache.start();
        assert (cache.getCacheConfiguration().persistence().preload().booleanValue());
        cache.put((Object)"k1", this.wrap("k1", "v"));
        cache.put((Object)"k2", this.wrap("k2", "v"), 111111L, TimeUnit.MILLISECONDS);
        cache.put((Object)"k3", this.wrap("k3", "v"), -1L, TimeUnit.MILLISECONDS, 222222L, TimeUnit.MILLISECONDS);
        cache.put((Object)"k4", this.wrap("k4", "v"), 333333L, TimeUnit.MILLISECONDS, 444444L, TimeUnit.MILLISECONDS);
        this.assertCacheEntry(cache, "k1", "v", -1L, -1L);
        this.assertCacheEntry(cache, "k2", "v", 111111L, -1L);
        this.assertCacheEntry(cache, "k3", "v", -1L, 222222L);
        this.assertCacheEntry(cache, "k4", "v", 333333L, 444444L);
        cache.stop();
        cache.start();
        this.assertCacheEntry(cache, "k1", "v", -1L, -1L);
        this.assertCacheEntry(cache, "k2", "v", 111111L, -1L);
        this.assertCacheEntry(cache, "k3", "v", -1L, 222222L);
        this.assertCacheEntry(cache, "k4", "v", 333333L, 444444L);
    }

    public void testPreloadStoredAsBinary() {
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        this.createCacheStoreConfig(cb.persistence(), "testPreloadStoredAsBinary", true).memory().storageType(StorageType.BINARY);
        TestingUtil.defineConfiguration(this.cacheManager, "testPreloadStoredAsBinary", cb.build());
        Cache cache = this.cacheManager.getCache("testPreloadStoredAsBinary");
        cache.start();
        assert (cache.getCacheConfiguration().persistence().preload().booleanValue());
        AssertJUnit.assertEquals((Object)StorageType.BINARY, (Object)cache.getCacheConfiguration().memory().storageType());
        byte[] pictureBytes = new byte[]{1, 82, 123, 19};
        cache.put((Object)"k1", (Object)this.createEmptyPerson("1"));
        cache.put((Object)"k2", (Object)new Person("2", null, pictureBytes, null, null, false, 4.6, 5.6f, 8.4, 9.2f), 111111L, TimeUnit.MILLISECONDS);
        cache.put((Object)"k3", (Object)new Person("3", null, null, Sex.MALE, null, false, 4.7, 5.7f, 8.5, 9.3f), -1L, TimeUnit.MILLISECONDS, 222222L, TimeUnit.MILLISECONDS);
        cache.put((Object)"k4", (Object)new Person("4", new Address("Street", "City", 12345), null, null, null, true, 4.8, 5.8f, 8.6, 9.4f), 333333L, TimeUnit.MILLISECONDS, 444444L, TimeUnit.MILLISECONDS);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("EST"));
        calendar.set(2009, 2, 18, 3, 22, 57);
        calendar.setTimeInMillis(calendar.getTimeInMillis() / 1000L * 1000L);
        Date infinispanBirthDate = calendar.getTime();
        Person infinispanPerson = this.createEmptyPerson("Infinispan");
        infinispanPerson.setBirthDate(infinispanBirthDate);
        infinispanPerson.setAcceptedToS(true);
        cache.put((Object)"Infinispan", (Object)infinispanPerson);
        cache.getAdvancedCache().getDataContainer().clear();
        this.assertPersonEqual(this.createEmptyPerson("1"), (Person)cache.get((Object)"k1"));
        Person person2 = this.createEmptyPerson("2");
        person2.setPicture(pictureBytes);
        person2.setMoneyOwned(4.6);
        person2.setMoneyOwed(5.6f);
        person2.setDecimalField(8.4);
        person2.setRealField(9.2f);
        this.assertPersonEqual(person2, (Person)cache.get((Object)"k2"));
        Person person3 = this.createEmptyPerson("3");
        person3.setSex(Sex.MALE);
        person3.setMoneyOwned(4.7);
        person3.setMoneyOwed(5.7f);
        person3.setDecimalField(8.5);
        person3.setRealField(9.3f);
        this.assertPersonEqual(person3, (Person)cache.get((Object)"k3"));
        this.assertPersonEqual(new Person("4", new Address("Street", "City", 12345), null, null, null, true, 4.8, 5.8f, 8.6, 9.4f), (Person)cache.get((Object)"k4"));
        this.assertPersonEqual(infinispanPerson, (Person)cache.get((Object)"Infinispan"));
        cache.stop();
        cache.start();
        AssertJUnit.assertEquals((int)5, (int)cache.entrySet().size());
        this.assertPersonEqual(this.createEmptyPerson("1"), (Person)cache.get((Object)"k1"));
        this.assertPersonEqual(person2, (Person)cache.get((Object)"k2"));
        this.assertPersonEqual(person3, (Person)cache.get((Object)"k3"));
        this.assertPersonEqual(new Person("4", new Address("Street", "City", 12345), null, null, null, true, 4.8, 5.8f, 8.6, 9.4f), (Person)cache.get((Object)"k4"));
        this.assertPersonEqual(infinispanPerson, (Person)cache.get((Object)"Infinispan"));
    }

    protected Person createEmptyPerson(String name) {
        return new Person(name);
    }

    public void testStoreByteArrays(Method m) throws PersistenceException {
        ConfigurationBuilder base = this.getDefaultCacheConfiguration();
        TestingUtil.defineConfiguration(this.cacheManager, m.getName(), this.configureCacheLoader(base, m.getName(), true).build());
        Cache cache = this.cacheManager.getCache(m.getName());
        byte[] key = new byte[]{1, 2, 3};
        byte[] value = new byte[]{4, 5, 6};
        cache.put((Object)key, (Object)value);
        byte[] lookupKey = new byte[]{1, 2, 3};
        byte[] found = (byte[])cache.get((Object)lookupKey);
        AssertJUnit.assertNotNull((Object)found);
        AssertJUnit.assertArrayEquals((byte[])value, (byte[])found);
        cache.evict((Object)key);
        found = (byte[])cache.get((Object)lookupKey);
        AssertJUnit.assertNotNull((Object)found);
        AssertJUnit.assertArrayEquals((byte[])value, (byte[])found);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveCache() {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.globalState().persistentLocation(CommonsTestingUtil.tmpDirectory(this.getClass()));
        global.serialization().addContextInitializer(this.getSerializationContextInitializer());
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        String cacheName = "testRemoveCache";
        this.createCacheStoreConfig(cb.persistence(), "testRemoveCache", true);
        EmbeddedCacheManager local = this.createCacheManager(true, global, cb);
        try {
            local.defineConfiguration("testRemoveCache", local.getDefaultCacheConfiguration());
            Cache cache = local.getCache("testRemoveCache");
            AssertJUnit.assertTrue((boolean)local.isRunning("testRemoveCache"));
            cache.put((Object)"1", this.wrap("1", "v1"));
            this.assertCacheEntry(cache, "1", "v1", -1L, -1L);
            local.administration().removeCache("testRemoveCache");
            AssertJUnit.assertFalse((boolean)local.isRunning("testRemoveCache"));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(local);
            throw throwable;
        }
        TestingUtil.killCacheManagers(local);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveCacheWithPassivation() {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.globalState().persistentLocation(CommonsTestingUtil.tmpDirectory(this.getClass()));
        global.serialization().addContextInitializer(this.getSerializationContextInitializer());
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        String cacheName = "testRemoveCacheWithPassivation";
        this.createCacheStoreConfig(cb.persistence().passivation(true), "testRemoveCacheWithPassivation", true);
        EmbeddedCacheManager local = this.createCacheManager(true, global, cb);
        try {
            local.defineConfiguration("testRemoveCacheWithPassivation", local.getDefaultCacheConfiguration());
            Cache cache = local.getCache("testRemoveCacheWithPassivation");
            AssertJUnit.assertTrue((boolean)local.isRunning("testRemoveCacheWithPassivation"));
            cache.put((Object)"1", this.wrap("1", "v1"));
            this.assertCacheEntry(cache, "1", "v1", -1L, -1L);
            ByRef passivate = new ByRef((Object)false);
            PersistenceManager actual = (PersistenceManager)ComponentRegistry.componentOf((Cache)cache, PersistenceManager.class);
            TrackingPersistenceManager stub = new TrackingPersistenceManager(actual, (ByRef<Boolean>)passivate);
            TestingUtil.replaceComponent(cache, PersistenceManager.class, stub, true);
            local.administration().removeCache("testRemoveCacheWithPassivation");
            AssertJUnit.assertFalse((boolean)local.isRunning("testRemoveCacheWithPassivation"));
            AssertJUnit.assertFalse((boolean)((Boolean)passivate.get()));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(local);
            throw throwable;
        }
        TestingUtil.killCacheManagers(local);
    }

    public void testPutAllBatch() {
        int numberOfEntries = 100;
        String cacheName = "testPutAllBatch";
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        this.createCacheStoreConfig(cb.persistence(), cacheName, false);
        TestingUtil.defineConfiguration(this.cacheManager, cacheName, cb.build());
        Cache cache = this.cacheManager.getCache(cacheName);
        Map<String, Object> entriesMap = IntStream.range(0, numberOfEntries).boxed().collect(Collectors.toMap(Object::toString, i -> this.wrap(i.toString(), "Val" + i)));
        cache.putAll(entriesMap);
        AssertJUnit.assertEquals((int)numberOfEntries, (int)cache.size());
        WaitDelegatingNonBlockingStore store = TestingUtil.getFirstStoreWait(cache);
        for (int i2 = 0; i2 < numberOfEntries; ++i2) {
            AssertJUnit.assertNotNull((String)("Entry for key: " + i2 + " was null"), store.loadEntry(this.toStorage(cache, Integer.toString(i2))));
        }
    }

    public void testIterator() {
        int numberOfEntries = 100;
        String cacheName = "testIterator";
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        this.createCacheStoreConfig(cb.persistence(), cacheName, false);
        TestingUtil.defineConfiguration(this.cacheManager, cacheName, cb.build());
        Cache cache = this.cacheManager.getCache(cacheName);
        Map<String, Object> entriesMap = IntStream.range(0, numberOfEntries).boxed().collect(Collectors.toMap(Object::toString, i -> this.wrap(i.toString(), "Val" + i)));
        cache.putAll(entriesMap);
        HashMap results = new HashMap(numberOfEntries);
        try (CloseableIterator iter = cache.getAdvancedCache().entrySet().iterator();){
            iter.forEachRemaining(e -> results.put((String)e.getKey(), e.getValue()));
        }
        AssertJUnit.assertEquals(entriesMap, results);
    }

    public void testIteratorWithSegment() {
        int numberOfEntries = 100;
        String cacheName = "testIteratorWithSegment";
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        this.createCacheStoreConfig(cb.persistence(), cacheName, false);
        TestingUtil.defineConfiguration(this.cacheManager, cacheName, cb.build());
        Cache cache = this.cacheManager.getCache(cacheName);
        IntSet segments = IntSets.mutableEmptySet();
        for (int i2 = 0; i2 < cache.getCacheConfiguration().clustering().hash().numSegments(); ++i2) {
            if (i2 % 2 != 0) continue;
            segments.set(i2);
        }
        Map<String, Object> entriesMap = IntStream.range(0, numberOfEntries).boxed().collect(Collectors.toMap(Object::toString, i -> this.wrap(i.toString(), "Val" + i)));
        cache.putAll(entriesMap);
        KeyPartitioner kp = TestingUtil.extractComponent(cache, KeyPartitioner.class);
        Map<String, Object> targetMap = entriesMap.entrySet().stream().filter(e -> segments.contains(kp.getSegment(e.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        HashMap results = new HashMap(numberOfEntries);
        try (CacheStream stream = cache.getAdvancedCache().entrySet().stream();){
            stream.filterKeySegments(segments).iterator().forEachRemaining(e -> results.put((String)e.getKey(), e.getValue()));
        }
        AssertJUnit.assertEquals(targetMap, results);
    }

    Object fromStorage(Cache<?, ?> cache, Object value) {
        return cache.getAdvancedCache().getValueDataConversion().withRequestMediaType(MediaType.APPLICATION_OBJECT).fromStorage(value);
    }

    Object toStorage(Cache<?, ?> cache, Object key) {
        return cache.getAdvancedCache().getKeyDataConversion().withRequestMediaType(MediaType.APPLICATION_OBJECT).toStorage(key);
    }

    public void testLoadEntrySet() {
        int numberOfEntries = 10;
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        this.createCacheStoreConfig(cb.persistence(), "testLoadEntrySet", true);
        Configuration configuration = cb.build();
        TestingUtil.defineConfiguration(this.cacheManager, "testLoadEntrySet", configuration);
        Cache cache = this.cacheManager.getCache("testLoadEntrySet");
        Map<String, Object> entriesMap = IntStream.range(0, numberOfEntries).boxed().collect(Collectors.toMap(Object::toString, i -> this.wrap(i.toString(), "Val" + i)));
        cache.putAll(entriesMap);
        cache.stop();
        cache.start();
        CacheSet set = cache.entrySet();
        AssertJUnit.assertEquals((int)numberOfEntries, (int)cache.size());
        AssertJUnit.assertEquals((int)numberOfEntries, (int)set.size());
        set.forEach(e -> AssertJUnit.assertEquals(entriesMap.get(e.getKey()), e.getValue()));
    }

    public void testReloadWithEviction() {
        int numberOfEntries = 10;
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        this.createCacheStoreConfig(cb.persistence(), "testReloadWithEviction", false).memory().size((long)(numberOfEntries / 2)).evictionType(EvictionType.COUNT);
        TestingUtil.defineConfiguration(this.cacheManager, "testReloadWithEviction", cb.build());
        Cache cache = this.cacheManager.getCache("testReloadWithEviction");
        Map<String, Object> entriesMap = IntStream.range(0, numberOfEntries).boxed().collect(Collectors.toMap(Object::toString, i -> this.wrap(i.toString(), "Val" + i)));
        cache.putAll(entriesMap);
        AssertJUnit.assertEquals((int)numberOfEntries, (int)cache.size());
        entriesMap.forEach((k, v) -> AssertJUnit.assertEquals((Object)v, (Object)cache.get(k)));
        cache.stop();
        cache.start();
        AssertJUnit.assertEquals((int)numberOfEntries, (int)cache.size());
        entriesMap.forEach((k, v) -> AssertJUnit.assertEquals((Object)v, (Object)cache.get(k)));
    }

    protected ConfigurationBuilder configureCacheLoader(ConfigurationBuilder base, String cacheName, boolean purge) {
        ConfigurationBuilder cfg = base == null ? this.getDefaultCacheConfiguration() : base;
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        this.createCacheStoreConfig(cfg.persistence(), cacheName, false);
        ((StoreConfigurationBuilder)cfg.persistence().stores().get(0)).purgeOnStartup(purge);
        return cfg;
    }

    private void assertCacheEntry(Cache cache, String key, String value, long lifespanMillis, long maxIdleMillis) {
        DataContainer dc = cache.getAdvancedCache().getDataContainer();
        InternalCacheEntry ice = dc.get(this.toStorage(cache, key));
        AssertJUnit.assertNotNull((Object)ice);
        AssertJUnit.assertEquals((String)value, (String)this.unwrap(this.fromStorage(cache, ice.getValue())));
        AssertJUnit.assertEquals((long)lifespanMillis, (long)ice.getLifespan());
        AssertJUnit.assertEquals((long)maxIdleMillis, (long)ice.getMaxIdle());
        if (lifespanMillis > -1L) assert (ice.getCreated() > -1L) : "Lifespan is set but created time is not";
        if (maxIdleMillis > -1L) assert (ice.getLastUsed() > -1L) : "Max idle is set but last used is not";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPurgeWithConcurrentUpdate() throws InterruptedException, TimeoutException, ExecutionException {
        String cacheName = "testPurgeWithConcurrentUpdate";
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        if (cb.clustering().cacheMode() != CacheMode.LOCAL) {
            return;
        }
        cb.expiration().wakeUpInterval(Long.MAX_VALUE);
        this.createCacheStoreConfig(cb.persistence(), cacheName, false);
        TestingUtil.defineConfiguration(this.cacheManager, cacheName, cb.build());
        TestingUtil.replaceComponent((CacheContainer)this.cacheManager, TimeService.class, this.timeService, true);
        Cache cache = this.cacheManager.getCache(cacheName);
        WaitDelegatingNonBlockingStore store = TestingUtil.getFirstStoreWait(cache);
        if (!store.characteristics().contains(NonBlockingStore.Characteristic.EXPIRATION)) {
            return;
        }
        cache.put((Object)"expired-key", (Object)"expired-value", 10L, TimeUnit.MILLISECONDS);
        this.timeService.advance(11L);
        CheckPoint putCheckpoint = new CheckPoint();
        putCheckpoint.triggerForever("after_release");
        PersistenceManager original = Mocks.blockingMock(putCheckpoint, PersistenceManager.class, cache, (stub, m) -> ((PersistenceManager)stub.when(m)).deleteFromAllStores(ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (Predicate)ArgumentMatchers.any()), new Class[0]);
        try {
            Future<Object> putFuture = this.fork(() -> cache.put((Object)"expired-key", (Object)"non-expired-value", 10L, TimeUnit.HOURS));
            putCheckpoint.awaitStrict("before_invocation", 10L, TimeUnit.SECONDS);
            CheckPoint expirationCheckPoint = new CheckPoint();
            expirationCheckPoint.triggerForever("after_release");
            expirationCheckPoint.triggerForever("before_release");
            Mocks.blockingMock(expirationCheckPoint, InternalDataContainer.class, cache, (stub, m) -> ((InternalDataContainer)stub.when(m)).compute(ArgumentMatchers.any(), (DataContainer.ComputeAction)ArgumentMatchers.any()), new Class[0]);
            Future<Void> expirationFuture = this.fork(() -> (Void)CompletionStages.join((CompletionStage)TestingUtil.extractComponent(cache, PersistenceManager.class).purgeExpired()));
            expirationCheckPoint.awaitStrict("before_invocation", 10L, TimeUnit.SECONDS);
            putCheckpoint.triggerForever("before_release");
            putFuture.get(10L, TimeUnit.SECONDS);
            expirationFuture.get(10L, TimeUnit.SECONDS);
        }
        finally {
            original.stop();
        }
    }

    @SurvivesRestarts
    static class TrackingPersistenceManager
    extends DelegatingPersistenceManager {
        private final ByRef<Boolean> passivate;

        public TrackingPersistenceManager(PersistenceManager actual, ByRef<Boolean> passivate) {
            super(actual);
            this.passivate = passivate;
        }

        public void start() {
        }

        public <K, V> CompletionStage<Void> writeEntries(Iterable<MarshallableEntry<K, V>> iterable, Predicate<? super StoreConfiguration> predicate) {
            this.passivate.set((Object)true);
            return super.writeEntries(iterable, predicate);
        }
    }
}

