/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.infinispan.Cache;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.manager.PersistenceManagerImpl;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.StoreUnavailableException;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@CleanupAfterMethod
@Test(testName="persistence.WriteBehindFaultToleranceTest", groups={"functional"})
public class WriteBehindFaultToleranceTest
extends SingleCacheManagerTest {
    private static final int AVAILABILITY_INTERVAL = 10;

    private Cache<Object, Object> createManagerAndGetCache(boolean failSilently, int queueSize) {
        GlobalConfigurationBuilder globalConfiguration = new GlobalConfigurationBuilder();
        ConfigurationBuilder config = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
        ((DummyInMemoryStoreConfigurationBuilder)config.persistence().availabilityInterval(10).addStore(DummyInMemoryStoreConfigurationBuilder.class)).async().enable().modificationQueueSize(queueSize).failSilently(failSilently);
        this.cacheManager = TestCacheManagerFactory.createCacheManager(globalConfiguration, config);
        return this.cacheManager.getCache();
    }

    public void testBlockingOnStoreAvailabilityChange() throws InterruptedException, ExecutionException, TimeoutException {
        Cache<Object, Object> cache = this.createManagerAndGetCache(false, 1);
        PollingPersistenceManager pm = new PollingPersistenceManager();
        PersistenceManager oldPersistenceManager = (PersistenceManager)TestingUtil.replaceComponent(cache, PersistenceManager.class, pm, true);
        oldPersistenceManager.stop();
        Object asyncStore = TestingUtil.getStore(cache, 0, false);
        DummyInMemoryStore dims = (DummyInMemoryStore)TestingUtil.getStore(cache, 0, true);
        dims.setAvailable(true);
        cache.put((Object)1, (Object)1);
        WriteBehindFaultToleranceTest.eventually(() -> dims.loadEntry(1) != null);
        AssertJUnit.assertEquals((long)1L, (long)dims.size());
        dims.setAvailable(false);
        AssertJUnit.assertFalse((boolean)dims.checkAvailable());
        int pollCount = pm.pollCount.get();
        WriteBehindFaultToleranceTest.eventually(() -> pm.pollCount.get() > pollCount);
        AssertJUnit.assertTrue((boolean)((Boolean)CompletionStages.join((CompletionStage)asyncStore.isAvailable())));
        AssertJUnit.assertNotNull(TestingUtil.extractField(asyncStore, "delegateAvailableFuture"));
        AssertJUnit.assertTrue((boolean)pm.isAvailable());
        Future<Void> f = this.fork(() -> cache.putAll(this.intMap(0, 5)));
        AssertJUnit.assertEquals((long)1L, (long)dims.size());
        WriteBehindFaultToleranceTest.eventually(() -> !pm.isAvailable());
        Exceptions.expectException(StoreUnavailableException.class, () -> cache.putAll(this.intMap(10, 20)));
        AssertJUnit.assertEquals((long)1L, (long)dims.size());
        dims.setAvailable(true);
        AssertJUnit.assertTrue((boolean)((Boolean)CompletionStages.join((CompletionStage)asyncStore.isAvailable())));
        WriteBehindFaultToleranceTest.eventually(() -> ((PollingPersistenceManager)pm).isAvailable());
        f.get(10L, TimeUnit.SECONDS);
        cache.putAll(this.intMap(5, 10));
        this.eventuallyEquals(IntSets.immutableRangeSet((int)10), dims::keySet);
    }

    private Map<Integer, Integer> intMap(int start, int end) {
        return IntStream.range(start, end).boxed().collect(Collectors.toMap(Function.identity(), Function.identity()));
    }

    public void testWritesFailSilentlyWhenConfigured() {
        Cache<Object, Object> cache = this.createManagerAndGetCache(true, 1);
        DummyInMemoryStore dims = (DummyInMemoryStore)TestingUtil.getStore(cache, 0, true);
        AssertJUnit.assertTrue((boolean)dims.checkAvailable());
        cache.put((Object)1, (Object)1);
        WriteBehindFaultToleranceTest.eventually(() -> dims.loadEntry(1) != null);
        AssertJUnit.assertEquals((long)1L, (long)dims.size());
        dims.setAvailable(false);
        AssertJUnit.assertFalse((boolean)dims.checkAvailable());
        cache.put((Object)1, (Object)2);
        TestingUtil.sleepThread(1000L);
        dims.setAvailable(true);
        MarshallableEntry entry = dims.loadEntry(1);
        AssertJUnit.assertNotNull(entry);
        AssertJUnit.assertEquals((Object)1, (Object)entry.getValue());
        AssertJUnit.assertEquals((Object)2, (Object)cache.get((Object)1));
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return null;
    }

    @Override
    protected void setup() throws Exception {
    }

    static class PollingPersistenceManager
    extends PersistenceManagerImpl {
        final AtomicInteger pollCount = new AtomicInteger();

        PollingPersistenceManager() {
        }

        protected CompletionStage<Void> pollStoreAvailability() {
            this.pollCount.incrementAndGet();
            return super.pollStoreAvailability();
        }
    }
}

