/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.dummy;

import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser;
import org.infinispan.persistence.dummy.Attribute;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.dummy.Element;

@Namespaces(value={@Namespace(root="dummy-store"), @Namespace(uri="urn:infinispan:config:store:dummy:*", root="dummy-store")})
public class DummyInMemoryStoreConfigurationParser
implements ConfigurationParser {
    static final String NAMESPACE = "urn:infinispan:config:store:dummy:";

    public void readElement(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case DUMMY_STORE: {
                ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
                this.parseDummyCacheStore(reader, (DummyInMemoryStoreConfigurationBuilder)builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class));
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
            }
        }
    }

    private void parseDummyCacheStore(ConfigurationReader reader, DummyInMemoryStoreConfigurationBuilder builder) {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case SLOW: {
                    builder.slow(Boolean.parseBoolean(value));
                    continue block5;
                }
                case START_FAILURES: {
                    builder.startFailures(Integer.parseInt(value));
                    continue block5;
                }
                case STORE_NAME: {
                    builder.storeName(value);
                    continue block5;
                }
                default: {
                    Parser.parseStoreAttribute((ConfigurationReader)reader, (int)i, (AbstractStoreConfigurationBuilder)builder);
                }
            }
        }
        while (reader.inTag()) {
            Parser.parseStoreElement((ConfigurationReader)reader, (StoreConfigurationBuilder)builder);
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }
}

