/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.file;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.List;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.persistence.BaseStoreFunctionalTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit", "smoke"}, testName="persistence.file.SingleFileStoreFunctionalTest")
public class SingleFileStoreFunctionalTest
extends BaseStoreFunctionalTest {
    private String tmpDirectory;

    @BeforeClass
    protected void setUpTempDir() {
        this.tmpDirectory = CommonsTestingUtil.tmpDirectory(this.getClass());
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    @AfterClass
    protected void clearTempDir() {
        Util.recursiveFileRemove((String)this.tmpDirectory);
        new File(this.tmpDirectory).mkdirs();
    }

    @Override
    protected PersistenceConfigurationBuilder createCacheStoreConfig(PersistenceConfigurationBuilder persistence, String cacheName, boolean preload) {
        persistence.addSingleFileStore().location(this.tmpDirectory).preload(preload);
        return persistence;
    }

    public void testParsingEmptyElement() throws Exception {
        String config = TestingUtil.wrapXMLWithSchema("<cache-container default-cache=\"default\">   <local-cache name=\"default\">\n      <persistence passivation=\"false\"> \n         <single-file-store shared=\"false\" preload=\"true\"/> \n      </persistence>\n   </local-cache>\n</cache-container>");
        ConfigurationBuilderHolder holder = new ParserRegistry().parse(config);
        List storeConfigs = holder.getDefaultConfigurationBuilder().build().persistence().stores();
        AssertJUnit.assertEquals((int)1, (int)storeConfigs.size());
        SingleFileStoreConfiguration fileStoreConfig = (SingleFileStoreConfiguration)storeConfigs.get(0);
        AssertJUnit.assertNull((Object)fileStoreConfig.location());
        AssertJUnit.assertEquals((int)-1, (int)fileStoreConfig.maxEntries());
    }

    public void testParsingElement() throws Exception {
        String config = TestingUtil.wrapXMLWithoutSchema("<cache-container default-cache=\"default\">   <local-cache name=\"default\">\n      <persistence passivation=\"false\"> \n         <single-file-store path=\"other-location\" segmented=\"false\" max-entries=\"100\" shared=\"false\" preload=\"true\" fragmentation-factor=\"0.75\"/> \n      </persistence>\n   </local-cache>\n</cache-container>");
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        ConfigurationBuilderHolder holder = new ParserRegistry().parse(config);
        List storeConfigs = holder.getDefaultConfigurationBuilder().build().persistence().stores();
        AssertJUnit.assertEquals((int)1, (int)storeConfigs.size());
        SingleFileStoreConfiguration fileStoreConfig = (SingleFileStoreConfiguration)storeConfigs.get(0);
        AssertJUnit.assertEquals((String)"other-location", (String)fileStoreConfig.location());
        AssertJUnit.assertEquals((int)100, (int)fileStoreConfig.maxEntries());
        AssertJUnit.assertEquals((float)0.75f, (float)fileStoreConfig.fragmentationFactor(), (float)0.0f);
        Util.recursiveFileRemove((String)"other-location");
    }
}

