/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.keymappers;

import java.util.UUID;
import org.infinispan.commons.util.Util;
import org.infinispan.persistence.keymappers.DefaultTwoWayKey2StringMapper;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.keymappers.DefaultTwoWayKey2StringMapperTest")
public class DefaultTwoWayKey2StringMapperTest {
    DefaultTwoWayKey2StringMapper mapper = new DefaultTwoWayKey2StringMapper();

    public void testKeyMapper() {
        String skey = this.mapper.getStringMapping((Object)"k1");
        assert (skey.equals("k1"));
        skey = this.mapper.getStringMapping((Object)100);
        assert (!skey.equals("100"));
        Integer i = (Integer)this.mapper.getKeyMapping(skey);
        assert (i == 100);
        skey = this.mapper.getStringMapping((Object)Boolean.TRUE);
        assert (!skey.equalsIgnoreCase("true"));
        Boolean b = (Boolean)this.mapper.getKeyMapping(skey);
        assert (b.booleanValue());
        skey = this.mapper.getStringMapping((Object)3.141592);
        assert (!skey.equals("3.141592"));
        Double d = (Double)this.mapper.getKeyMapping(skey);
        assert (d == 3.141592);
        UUID uuid = Util.threadLocalRandomUUID();
        skey = this.mapper.getStringMapping((Object)uuid);
        assert (!uuid.equals(uuid.toString()));
        UUID u = (UUID)this.mapper.getKeyMapping(skey);
        assert (u.equals(uuid));
    }

    public void testPrimitivesAreSupported() {
        assert (this.mapper.isSupportedType(Integer.class));
        assert (this.mapper.isSupportedType(Byte.class));
        assert (this.mapper.isSupportedType(Short.class));
        assert (this.mapper.isSupportedType(Long.class));
        assert (this.mapper.isSupportedType(Double.class));
        assert (this.mapper.isSupportedType(Float.class));
        assert (this.mapper.isSupportedType(Boolean.class));
        assert (this.mapper.isSupportedType(String.class));
    }

    public void testTwoWayContract() {
        Object[] toTest;
        for (Object o : toTest = new Object[]{0, (byte)1, (short)2, 3.4, Float.valueOf(3.5f), false, "some string"}) {
            Class<?> type = o.getClass();
            String rep = this.mapper.getStringMapping(o);
            assert (o.equals(this.mapper.getKeyMapping(rep))) : String.format("Failed on type %s and value %s", type, rep);
        }
    }

    public void testString() {
        assert (this.mapper.isSupportedType(String.class));
        assert (this.assertWorks("")) : "Expected empty string, was " + this.mapper.getStringMapping((Object)"");
        assert (this.assertWorks("mircea")) : "Expected 'mircea', was " + this.mapper.getStringMapping((Object)"mircea");
    }

    public void testShort() {
        assert (this.mapper.isSupportedType(Short.class));
        assert (this.assertWorks((short)2));
    }

    public void testByte() {
        assert (this.mapper.isSupportedType(Byte.class));
        assert (this.assertWorks((byte)2));
    }

    public void testLong() {
        assert (this.mapper.isSupportedType(Long.class));
        assert (this.assertWorks(2L));
    }

    public void testInteger() {
        assert (this.mapper.isSupportedType(Integer.class));
        assert (this.assertWorks(2));
    }

    public void testDouble() {
        assert (this.mapper.isSupportedType(Double.class));
        assert (this.assertWorks(2.4));
    }

    public void testFloat() {
        assert (this.mapper.isSupportedType(Float.class));
        assert (this.assertWorks(Float.valueOf(2.1f)));
    }

    public void testBoolean() {
        assert (this.mapper.isSupportedType(Boolean.class));
        assert (this.assertWorks(true));
        assert (this.assertWorks(false));
    }

    public void testUuid() {
        assert (this.mapper.isSupportedType(UUID.class));
        assert (this.assertWorks(Util.threadLocalRandomUUID()));
    }

    private boolean assertWorks(Object key) {
        return this.mapper.getKeyMapping(this.mapper.getStringMapping(key)).equals(key);
    }
}

