/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.manager;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.subscribers.TestSubscriber;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.persistence.impl.MarshalledEntryUtil;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.manager.PersistenceManagerImpl;
import org.infinispan.persistence.support.DelayStore;
import org.infinispan.persistence.support.FailStore;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestException;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.reactivestreams.Publisher;
import org.testng.AssertJUnit;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.PersistenceManagerTest")
@CleanupAfterMethod
public class PersistenceManagerTest
extends SingleCacheManagerTest {
    private boolean transactional;

    private PersistenceManagerTest transactional(boolean transactional) {
        this.transactional = transactional;
        return this;
    }

    @Factory
    public static Object[] factory() {
        return new Object[]{new PersistenceManagerTest().transactional(true), new PersistenceManagerTest().transactional(false)};
    }

    @Override
    protected String parameters() {
        return "transactional=" + this.transactional;
    }

    public void testPublishAfterStop() {
        PersistenceManager persistenceManager = TestingUtil.extractComponent(this.cache, PersistenceManager.class);
        KeyPartitioner keyPartitioner = TestingUtil.extractComponent(this.cache, KeyPartitioner.class);
        String key = "k";
        this.insertEntry(persistenceManager, keyPartitioner, key, "v");
        persistenceManager.stop();
        ByRef tRef = new ByRef(null);
        Flowable.fromPublisher((Publisher)persistenceManager.publishEntries(true, true)).blockingSubscribe(ignore -> AssertJUnit.fail((String)"shouldn't run"), arg_0 -> ((ByRef)tRef).set(arg_0));
        Throwable t = (Throwable)tRef.get();
        Exceptions.assertException(IllegalLifecycleStateException.class, (Throwable)t);
    }

    public void testStopDuringPublish() throws ExecutionException, InterruptedException, TimeoutException {
        PersistenceManager persistenceManager = TestingUtil.extractComponent(this.cache, PersistenceManager.class);
        KeyPartitioner keyPartitioner = TestingUtil.extractComponent(this.cache, KeyPartitioner.class);
        this.insertEntry(persistenceManager, keyPartitioner, "k1", "v1");
        this.insertEntry(persistenceManager, keyPartitioner, "k2", "v2");
        this.insertEntry(persistenceManager, keyPartitioner, "k3", "v3");
        DelayStore store = (DelayStore)TestingUtil.getFirstStore(this.cache);
        store.delayBeforeEmit(1);
        CountDownLatch before = new CountDownLatch(1);
        CountDownLatch after = new CountDownLatch(1);
        Future<Integer> publisherFuture = this.fork(() -> {
            TestSubscriber subscriber = TestSubscriber.create((long)0L);
            Flowable.fromPublisher((Publisher)persistenceManager.publishEntries(true, true)).subscribe((FlowableSubscriber)subscriber);
            before.countDown();
            AssertJUnit.assertTrue((boolean)after.await(10L, TimeUnit.SECONDS));
            subscriber.request(Long.MAX_VALUE);
            subscriber.await(10L, TimeUnit.SECONDS);
            subscriber.assertNoErrors();
            subscriber.assertComplete();
            return subscriber.values().size();
        });
        AssertJUnit.assertTrue((boolean)before.await(30L, TimeUnit.SECONDS));
        Future<Void> stopFuture = this.fork(() -> ((PersistenceManager)persistenceManager).stop());
        Thread.sleep(50L);
        AssertJUnit.assertFalse((boolean)stopFuture.isDone());
        AssertJUnit.assertFalse((boolean)publisherFuture.isDone());
        after.countDown();
        Thread.sleep(50L);
        AssertJUnit.assertFalse((boolean)stopFuture.isDone());
        AssertJUnit.assertFalse((boolean)publisherFuture.isDone());
        store.endDelay();
        Integer count = publisherFuture.get(30L, TimeUnit.SECONDS);
        stopFuture.get(30L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((int)3, (int)count);
    }

    public void testEarlyTerminatedPublish() {
        PersistenceManager persistenceManager = TestingUtil.extractComponent(this.cache, PersistenceManager.class);
        KeyPartitioner keyPartitioner = TestingUtil.extractComponent(this.cache, KeyPartitioner.class);
        for (int i = 0; i < 140; ++i) {
            String key = "k" + i;
            this.insertEntry(persistenceManager, keyPartitioner, key, "v");
        }
        DelayStore store = (DelayStore)TestingUtil.getFirstStore(this.cache);
        store.delayBeforeEmit(1);
        PersistenceManagerImpl pmImpl = (PersistenceManagerImpl)persistenceManager;
        AssertJUnit.assertFalse((boolean)pmImpl.anyLocksHeld());
        AssertJUnit.assertFalse((boolean)this.cache.isEmpty());
        AssertJUnit.assertFalse((boolean)pmImpl.anyLocksHeld());
        store.endDelay();
    }

    public void testStoreExceptionInWrite() {
        PersistenceManager pm = TestingUtil.extractComponent(this.cache, PersistenceManager.class);
        KeyPartitioner keyPartitioner = TestingUtil.extractComponent(this.cache, KeyPartitioner.class);
        DelayStore store1 = (DelayStore)TestingUtil.getStore(this.cache, 0, true);
        FailStore store2 = (FailStore)TestingUtil.getStore(this.cache, 1, true);
        store2.failModification(2);
        String key = "k";
        int segment = keyPartitioner.getSegment((Object)key);
        Exceptions.expectCompletionException(TestException.class, (CompletionStage)pm.writeToAllNonTxStores(MarshalledEntryUtil.create(key, "v", this.cache), segment, (Predicate)PersistenceManager.AccessMode.BOTH));
        AssertJUnit.assertTrue((boolean)store1.contains(key));
        Exceptions.expectCompletionException(TestException.class, (CompletionStage)pm.deleteFromAllStores((Object)key, segment, (Predicate)PersistenceManager.AccessMode.BOTH));
        AssertJUnit.assertFalse((boolean)store1.contains(key));
    }

    public void testStoreNotWrittenOnRemoveMiss() {
        if (this.transactional) {
            return;
        }
        FailStore store2 = (FailStore)TestingUtil.getStore(this.cache, 1, true);
        store2.failModification(1);
        this.cache.remove((Object)"k");
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(this.transactional);
        cfg.persistence().addStore(DelayStore.ConfigurationBuilder.class);
        cfg.persistence().addStore(FailStore.ConfigurationBuilder.class);
        cfg.persistence().addStore(FailStore.ConfigurationBuilder.class);
        return TestCacheManagerFactory.createCacheManager(cfg);
    }

    private void insertEntry(PersistenceManager persistenceManager, KeyPartitioner keyPartitioner, String k, String v) {
        CompletionStages.join((CompletionStage)persistenceManager.writeToAllNonTxStores(MarshalledEntryUtil.create(k, v, this.cache), keyPartitioner.getSegment((Object)k), (Predicate)PersistenceManager.AccessMode.BOTH));
    }
}

