/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="remoting.NonExistentCacheTest", groups={"functional"})
public class NonExistentCacheTest
extends AbstractInfinispanTest {
    private EmbeddedCacheManager createCacheManager() {
        ConfigurationBuilder c = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
        c.clustering().cacheMode(CacheMode.REPL_SYNC).transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        GlobalConfigurationBuilder gc = GlobalConfigurationBuilder.defaultClusteredBuilder();
        return TestCacheManagerFactory.createClusteredCacheManager(gc, c);
    }

    public void testPutWithNonExistentCache() {
        EmbeddedCacheManager cm1 = null;
        EmbeddedCacheManager cm2 = null;
        try {
            cm1 = this.createCacheManager();
            cm2 = this.createCacheManager();
            cm1.getCache();
            cm2.getCache();
            cm1.getCache().put((Object)"k", (Object)"v");
            AssertJUnit.assertEquals((Object)"v", (Object)cm1.getCache().get((Object)"k"));
            AssertJUnit.assertEquals((Object)"v", (Object)cm2.getCache().get((Object)"k"));
            cm1.defineConfiguration("newCache", cm1.getDefaultCacheConfiguration());
            cm1.getCache("newCache").put((Object)"k", (Object)"v");
            AssertJUnit.assertEquals((Object)"v", (Object)cm1.getCache("newCache").get((Object)"k"));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm1, cm2);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm1, cm2);
    }
}

