/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.jgroups;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerStartupException;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(testName="remoting.jgroups.NonExistingJGroupsConfigTest", groups={"functional"})
public class NonExistingJGroupsConfigTest
extends AbstractInfinispanTest {
    public void channelLookupTest() {
        String config = "<infinispan>\n<jgroups>\n   <stack-file name=\"dummy\" path=\"nosuchfile.xml\"/>\n</jgroups>\n<cache-container default-cache=\"default\">   <transport stack=\"dummy\" cluster=\"demoCluster\" />\n   <replicated-cache name=\"default\" />\n</cache-container>\n</infinispan>";
        Exceptions.expectException(CacheConfigurationException.class, (String)"ISPN000365:.*", () -> {
            DefaultCacheManager cm = null;
            try {
                ConfigurationBuilderHolder cbh = new ParserRegistry().parse((InputStream)new ByteArrayInputStream(config.getBytes()), Void2 -> {
                    throw new FileNotFoundException();
                }, MediaType.APPLICATION_XML);
                cm = new DefaultCacheManager(cbh, true);
            }
            catch (Throwable throwable) {
                TestingUtil.killCacheManagers(new EmbeddedCacheManager[]{cm});
                throw throwable;
            }
            TestingUtil.killCacheManagers(new EmbeddedCacheManager[]{cm});
        });
    }

    public void brokenJGroupsConfigTest() {
        String config = "<infinispan>\n<jgroups>\n   <stack-file name=\"dummy\" path=\"stacks/broken-tcp.xml\"/>\n</jgroups>\n<cache-container default-cache=\"default\">   <transport stack=\"dummy\" cluster=\"demoCluster\" />\n   <replicated-cache name=\"default\" />\n</cache-container>\n</infinispan>";
        Exceptions.expectException(EmbeddedCacheManagerStartupException.class, CacheConfigurationException.class, (String)"ISPN000541:.*", () -> {
            DefaultCacheManager cm = null;
            try {
                cm = new DefaultCacheManager((InputStream)new ByteArrayInputStream(config.getBytes()));
            }
            catch (Throwable throwable) {
                TestingUtil.killCacheManagers(new EmbeddedCacheManager[]{cm});
                throw throwable;
            }
            TestingUtil.killCacheManagers(new EmbeddedCacheManager[]{cm});
        });
    }
}

