/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.LongConsumer;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.TimeoutException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.transport.BackupResponse;
import org.infinispan.remoting.transport.XSiteAsyncAckListener;
import org.infinispan.remoting.transport.jgroups.JGroupsBackupResponse;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.xsite.XSiteBackup;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="remoting.transport.jgroups.JGroupsBackupResponseUnitTest")
public class JGroupsBackupResponseUnitTest
extends AbstractInfinispanTest {
    private final ControlledTimeService timeService = new ControlledTimeService();

    private static Map<XSiteBackup, CompletableFuture<ValidResponse>> createResponseMap(Collection<XSiteBackup> backups) {
        HashMap<XSiteBackup, CompletableFuture<ValidResponse>> responses = new HashMap<XSiteBackup, CompletableFuture<ValidResponse>>(backups.size());
        for (XSiteBackup backup : backups) {
            responses.put(backup, new CompletableFuture());
        }
        return responses;
    }

    private static XSiteBackup createSyncBackup(String siteName, long timeoutMs) {
        return new XSiteBackup(siteName, true, timeoutMs);
    }

    private static XSiteBackup createAsyncBackup(String siteName) {
        return new XSiteBackup(siteName, false, 15000L);
    }

    public void testNoWaitForAsyncWithMix() {
        ArrayList<XSiteBackup> backups = new ArrayList<XSiteBackup>(2);
        backups.add(JGroupsBackupResponseUnitTest.createSyncBackup("sync", 10000L));
        backups.add(JGroupsBackupResponseUnitTest.createAsyncBackup("async"));
        Map<XSiteBackup, CompletableFuture<ValidResponse>> responses = JGroupsBackupResponseUnitTest.createResponseMap(backups);
        BackupResponse response = this.newBackupResponse(responses);
        Future<Void> waiting = this.waitBackupResponse(response);
        this.assertNotCompleted(waiting);
        responses.get(backups.get(0)).complete(null);
        this.assertCompleted(waiting);
    }

    public void testNoWaitForAsyncWith() {
        List<XSiteBackup> backups = Collections.singletonList(JGroupsBackupResponseUnitTest.createAsyncBackup("async-only"));
        Map<XSiteBackup, CompletableFuture<ValidResponse>> responses = JGroupsBackupResponseUnitTest.createResponseMap(backups);
        BackupResponse response = this.newBackupResponse(responses);
        Future<Void> waiting = this.waitBackupResponse(response);
        this.assertCompleted(waiting);
    }

    public void testAsyncListener() {
        Listener listener = new Listener();
        long sendTimestamp = this.timeService.time();
        ArrayList<XSiteBackup> backups = new ArrayList<XSiteBackup>(2);
        backups.add(JGroupsBackupResponseUnitTest.createAsyncBackup("async-1"));
        backups.add(JGroupsBackupResponseUnitTest.createAsyncBackup("async-2"));
        Map<XSiteBackup, CompletableFuture<ValidResponse>> responses = JGroupsBackupResponseUnitTest.createResponseMap(backups);
        BackupResponse backupResponse = this.newBackupResponse(responses);
        backupResponse.notifyAsyncAck((XSiteAsyncAckListener)listener);
        AssertJUnit.assertTrue((boolean)listener.queue.isEmpty());
        this.timeService.advance(10L);
        responses.get(backups.get(0)).complete(null);
        this.assertListenerData(listener, sendTimestamp, "async-1", null);
        this.timeService.advance(10L);
        CacheException exception = new CacheException("Test-Exception");
        responses.get(backups.get(1)).completeExceptionally(exception);
        this.assertListenerData(listener, sendTimestamp, "async-2", exception);
        AssertJUnit.assertTrue((boolean)listener.queue.isEmpty());
        AssertJUnit.assertEquals((long)TimeUnit.NANOSECONDS.toMillis(sendTimestamp), (long)backupResponse.getSendTimeMillis());
    }

    public void testSyncListener() {
        Listener listener = new Listener();
        ArrayList<XSiteBackup> backups = new ArrayList<XSiteBackup>(2);
        backups.add(JGroupsBackupResponseUnitTest.createSyncBackup("sync-1", 10000L));
        backups.add(JGroupsBackupResponseUnitTest.createAsyncBackup("async-2"));
        Map<XSiteBackup, CompletableFuture<ValidResponse>> responses = JGroupsBackupResponseUnitTest.createResponseMap(backups);
        BackupResponse backupResponse = this.newBackupResponse(responses);
        backupResponse.notifyFinish((LongConsumer)listener);
        AssertJUnit.assertTrue((boolean)listener.queue.isEmpty());
        Future<Void> waiting = this.waitBackupResponse(backupResponse);
        this.timeService.advance(10L);
        responses.get(backups.get(1)).complete(null);
        this.assertNotCompleted(waiting);
        AssertJUnit.assertTrue((boolean)listener.queue.isEmpty());
        this.timeService.advance(10L);
        responses.get(backups.get(0)).complete(null);
        this.assertCompleted(waiting);
        this.assertListenerData(listener, 20L, null, null);
        AssertJUnit.assertTrue((boolean)listener.queue.isEmpty());
    }

    public void testNoErrorsFromAsync() {
        long timeoutMs = 10000L;
        ArrayList<XSiteBackup> backups = new ArrayList<XSiteBackup>(3);
        backups.add(JGroupsBackupResponseUnitTest.createSyncBackup("sync-1", timeoutMs));
        backups.add(JGroupsBackupResponseUnitTest.createSyncBackup("sync-2", 2L * timeoutMs));
        backups.add(JGroupsBackupResponseUnitTest.createAsyncBackup("async"));
        Map<XSiteBackup, CompletableFuture<ValidResponse>> responses = JGroupsBackupResponseUnitTest.createResponseMap(backups);
        BackupResponse response = this.newBackupResponse(responses);
        this.timeService.advance(timeoutMs + 1L);
        Future<Void> waiting = this.waitBackupResponse(response);
        this.assertNotCompleted(waiting);
        CacheException exception = new CacheException("Test-Exception");
        responses.get(backups.get(1)).complete(null);
        responses.get(backups.get(2)).completeExceptionally(exception);
        this.assertCompleted(waiting);
        AssertJUnit.assertEquals((int)1, (int)response.getCommunicationErrors().size());
        AssertJUnit.assertEquals((int)1, (int)response.getFailedBackups().size());
        AssertJUnit.assertTrue((boolean)response.getCommunicationErrors().contains("sync-1"));
        AssertJUnit.assertTrue((boolean)response.getFailedBackups().containsKey("sync-1"));
        Exceptions.assertException(TimeoutException.class, (Throwable)((Throwable)response.getFailedBackups().get("sync-1")));
    }

    public void testEmpty() {
        ArrayList<XSiteBackup> backups = new ArrayList<XSiteBackup>(1);
        backups.add(JGroupsBackupResponseUnitTest.createAsyncBackup("async"));
        BackupResponse response = this.newBackupResponse(JGroupsBackupResponseUnitTest.createResponseMap(backups));
        AssertJUnit.assertTrue((boolean)response.isEmpty());
        backups.add(JGroupsBackupResponseUnitTest.createSyncBackup("sync", 10000L));
        response = this.newBackupResponse(JGroupsBackupResponseUnitTest.createResponseMap(backups));
        AssertJUnit.assertFalse((boolean)response.isEmpty());
    }

    private void assertListenerData(Listener listener, long sendTimestamp, String siteName, Throwable throwable) {
        try {
            ListenerData data = listener.queue.poll(10L, TimeUnit.SECONDS);
            AssertJUnit.assertNotNull((String)("Failed to get event for site " + siteName), (Object)data);
            AssertJUnit.assertEquals((String)siteName, (String)data.siteName);
            AssertJUnit.assertEquals((long)sendTimestamp, (long)data.time);
            AssertJUnit.assertEquals((Object)throwable, (Object)data.throwable);
        }
        catch (InterruptedException e) {
            AssertJUnit.fail((String)("Interrupted while waiting for event for site " + siteName));
        }
    }

    private void assertNotCompleted(Future<Void> future) {
        Exceptions.expectException(java.util.concurrent.TimeoutException.class, () -> future.get(1L, TimeUnit.SECONDS));
    }

    private void assertCompleted(Future<Void> future) {
        try {
            future.get(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | java.util.concurrent.TimeoutException e) {
            AssertJUnit.fail((String)"Backup Response must be completed by now!");
        }
    }

    private Future<Void> waitBackupResponse(BackupResponse response) {
        return this.fork(() -> ((BackupResponse)response).waitForBackupToFinish());
    }

    private BackupResponse newBackupResponse(Map<XSiteBackup, CompletableFuture<ValidResponse>> responses) {
        return new JGroupsBackupResponse(responses, (TimeService)this.timeService);
    }

    private static class Listener
    implements XSiteAsyncAckListener,
    LongConsumer {
        private final BlockingDeque<ListenerData> queue = new LinkedBlockingDeque<ListenerData>();

        private Listener() {
        }

        public void onAckReceived(long sendTimestampNanos, String siteName, Throwable throwable) {
            this.queue.add(new ListenerData(sendTimestampNanos, siteName, throwable));
        }

        @Override
        public void accept(long value) {
            this.queue.add(new ListenerData(value, null, null));
        }
    }

    private static class ListenerData {
        private final long time;
        private final String siteName;
        private final Throwable throwable;

        private ListenerData(long time, String siteName, Throwable throwable) {
            this.time = time;
            this.siteName = siteName;
            this.throwable = throwable;
        }
    }
}

