/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.BaseAuthorizationTest;
import org.infinispan.security.SecureCache;
import org.infinispan.security.SecureCacheTestDriver;
import org.infinispan.security.Security;
import org.infinispan.security.TestCachePermission;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="security.CacheAuthorizationTest")
public class CacheAuthorizationTest
extends BaseAuthorizationTest {
    public void testAllCombinations() throws Exception {
        Method[] allMethods = SecureCache.class.getMethods();
        HashSet<String> methodNames = new HashSet<String>();
        block4: for (Method m : allMethods) {
            StringBuilder s = new StringBuilder("test");
            String name = m.getName();
            s.append(name.substring(0, 1).toUpperCase());
            s.append(name.substring(1));
            for (Class<?> p : m.getParameterTypes()) {
                Package pkg = p.getPackage();
                if (pkg != null && pkg.getName().startsWith("java.util.function")) continue block4;
                s.append("_");
                s.append(p.getSimpleName().replaceAll("\\[\\]", "Array"));
            }
            methodNames.add(s.toString());
        }
        SecureCacheTestDriver driver = new SecureCacheTestDriver();
        SecureCache cache = (SecureCache)Security.doAs((Subject)ADMIN, () -> {
            Cache c = this.cacheManager.getCache();
            return c;
        });
        for (String methodName : methodNames) {
            Class<?> driverClass = driver.getClass();
            try {
                Method method = driverClass.getMethod(methodName, SecureCache.class);
                TestCachePermission annotation = method.getAnnotation(TestCachePermission.class);
                if (annotation == null) {
                    throw new Exception(String.format("Method %s on class %s is missing the TestCachePermission annotation", methodName, driver.getClass().getName()));
                }
                AuthorizationPermission expectedPerm = annotation.value();
                for (AuthorizationPermission perm : AuthorizationPermission.values()) {
                    if (perm == AuthorizationPermission.NONE) continue;
                    log.debugf("Method %s > %s", (Object)methodName, (Object)perm.toString());
                    if (expectedPerm == AuthorizationPermission.NONE) {
                        try {
                            method.invoke((Object)driver, cache);
                            continue;
                        }
                        catch (SecurityException e) {
                            throw new Exception(String.format("Unexpected SecurityException while invoking %s with permission %s", methodName, perm), e);
                        }
                    }
                    Security.doAs((Subject)((Subject)SUBJECTS.get(perm)), () -> {
                        try {
                            this.invokeCacheMethod(driver, (AdvancedCache<String, String>)cache, methodName, method, expectedPerm, perm);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                    this.invokeCacheMethod(driver, (AdvancedCache<String, String>)cache.withSubject((Subject)SUBJECTS.get(perm)), methodName, method, expectedPerm, perm);
                }
            }
            catch (NoSuchMethodException e) {
                throw new Exception(String.format("Class %s needs to declare a method with the following signature: public void %s(SecureCache<String, String> cache) {}\n", driver.getClass().getName(), methodName), e);
            }
        }
    }

    private void invokeCacheMethod(SecureCacheTestDriver driver, AdvancedCache<String, String> cache, String methodName, Method method, AuthorizationPermission expectedPerm, AuthorizationPermission perm) throws Exception {
        try {
            method.invoke((Object)driver, cache);
            if (!perm.implies(expectedPerm)) {
                throw new Exception(String.format("Expected SecurityException while invoking %s with permission %s", methodName, perm));
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SecurityException) {
                if (perm.implies(expectedPerm)) {
                    throw new Exception(String.format("Unexpected SecurityException while invoking %s with permission %s", methodName, perm), e);
                }
            }
            throw new Exception("Unexpected non-SecurityException", e);
        }
    }
}

