/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.statetransfer.StateResponseCommand;
import org.infinispan.commands.statetransfer.StateTransferStartCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.InCacheMode;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.util.ControlledRpcManager;
import org.jgroups.protocols.DISCARD;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.MergeDuringReplaceTest")
@CleanupAfterMethod
@InCacheMode(value={CacheMode.DIST_SYNC})
public class MergeDuringReplaceTest
extends MultipleCacheManagersTest {
    private DISCARD[] discard;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder defaultConfig = MergeDuringReplaceTest.getDefaultClusteredCacheConfig(this.cacheMode, false);
        this.createClusteredCaches(3, defaultConfig, new TransportFlags().withFD(true).withMerge(true));
        DISCARD d1 = TestingUtil.getDiscardForCache(this.manager(0));
        DISCARD d2 = TestingUtil.getDiscardForCache(this.manager(1));
        DISCARD d3 = TestingUtil.getDiscardForCache(this.manager(2));
        this.discard = new DISCARD[]{d1, d2, d3};
    }

    public void testMergeDuringReplace() throws Exception {
        String key = "myKey";
        String value = "myValue";
        this.cache(0).put((Object)"myKey", (Object)"myValue");
        LocalizedCacheTopology cacheTopology = this.advancedCache(0).getDistributionManager().getCacheTopology();
        ArrayList members = new ArrayList(cacheTopology.getMembers());
        List owners = cacheTopology.getDistribution((Object)"myKey").readOwners();
        members.removeAll(owners);
        int nonOwner = cacheTopology.getMembers().indexOf(members.get(0));
        Cache c = this.cache(nonOwner);
        List partition1 = this.caches();
        partition1.remove(c);
        ControlledRpcManager controlledRpcManager = ControlledRpcManager.replaceRpcManager(c, new Class[0]);
        controlledRpcManager.excludeCommands(StateTransferStartCommand.class, StateResponseCommand.class);
        Future<Boolean> future = this.fork(() -> c.replace((Object)"myKey", (Object)"myValue", (Object)"myNewValue"));
        ControlledRpcManager.BlockedRequest<ReplaceCommand> blockedReplace = controlledRpcManager.expectCommand(ReplaceCommand.class);
        this.discard[nonOwner].discardAll(true);
        TestingUtil.blockUntilViewsReceived(30000L, false, partition1.get(0), partition1.get(1));
        TestingUtil.blockUntilViewsReceived(30000L, false, c);
        TestingUtil.waitForNoRebalance(partition1.get(0), partition1.get(1));
        TestingUtil.waitForNoRebalance(c);
        blockedReplace.send().receiveAll();
        Assert.assertEquals((Object)future.get(10L, TimeUnit.SECONDS), (Object)Boolean.FALSE);
        controlledRpcManager.stopBlocking();
    }

    public int findNonOwner(String key) {
        for (Cache cache : this.caches()) {
            if (cache.getAdvancedCache().getDataContainer().containsKey((Object)key)) continue;
            return this.caches().indexOf(cache);
        }
        throw new IllegalStateException();
    }
}

