/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.statetransfer.StateResponseCommand;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.TestAddress;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.DefaultConsistentHash;
import org.infinispan.distribution.ch.impl.DefaultConsistentHashFactory;
import org.infinispan.distribution.ch.impl.HashFunctionPartitioner;
import org.infinispan.notifications.cachelistener.cluster.ClusterCacheNotifier;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.reactive.publisher.impl.LocalPublisherManager;
import org.infinispan.reactive.publisher.impl.Notifications;
import org.infinispan.reactive.publisher.impl.SegmentAwarePublisherSupplier;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.statetransfer.StateProviderImpl;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.TestKey;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.PersistentUUID;
import org.infinispan.topology.PersistentUUIDManager;
import org.infinispan.topology.PersistentUUIDManagerImpl;
import org.infinispan.transaction.impl.TransactionOriginatorChecker;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.StateProviderTest")
public class StateProviderTest {
    private static final Log log = LogFactory.getLog(StateProviderTest.class);
    private static final int NUM_SEGMENTS = 4;
    private static final TestAddress A = new TestAddress(0, "A");
    private static final TestAddress B = new TestAddress(1, "B");
    private static final TestAddress C = new TestAddress(2, "C");
    private static final TestAddress D = new TestAddress(3, "D");
    private static final TestAddress E = new TestAddress(4, "E");
    private static final TestAddress F = new TestAddress(5, "F");
    private static final TestAddress G = new TestAddress(6, "G");
    private static final PersistentUUIDManager persistentUUIDManager = new PersistentUUIDManagerImpl();
    private Configuration configuration;
    private Cache cache;
    private RpcManager rpcManager;
    private CommandsFactory commandsFactory;
    private ClusterCacheNotifier cacheNotifier;
    private PersistenceManager persistenceManager;
    private InternalDataContainer dataContainer;
    private TransactionTable transactionTable;
    private StateTransferLock stateTransferLock;
    private DistributionManager distributionManager;
    private LocalizedCacheTopology cacheTopology;
    private InternalEntryFactory ef;
    private LocalPublisherManager<?, ?> lpm;

    @BeforeMethod
    public void setUp() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().invocationBatching().enable().clustering().cacheMode(CacheMode.DIST_SYNC).clustering().stateTransfer().timeout(30000L).locking().lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis()).locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        this.configuration = cb.build();
        this.cache = (Cache)Mockito.mock(Cache.class);
        Mockito.when((Object)this.cache.getName()).thenReturn((Object)"testCache");
        this.rpcManager = (RpcManager)Mockito.mock(RpcManager.class);
        this.commandsFactory = (CommandsFactory)Mockito.mock(CommandsFactory.class);
        this.cacheNotifier = (ClusterCacheNotifier)Mockito.mock(ClusterCacheNotifier.class);
        this.persistenceManager = (PersistenceManager)Mockito.mock(PersistenceManager.class);
        this.dataContainer = (InternalDataContainer)Mockito.mock(InternalDataContainer.class);
        this.transactionTable = (TransactionTable)Mockito.mock(TransactionTable.class);
        this.stateTransferLock = (StateTransferLock)Mockito.mock(StateTransferLock.class);
        this.distributionManager = (DistributionManager)Mockito.mock(DistributionManager.class);
        this.ef = (InternalEntryFactory)Mockito.mock(InternalEntryFactory.class);
        this.lpm = (LocalPublisherManager)Mockito.mock(LocalPublisherManager.class);
        Mockito.when((Object)this.distributionManager.getCacheTopology()).thenAnswer(invocation -> this.cacheTopology);
    }

    public void test1() {
        List<Address> members1 = Arrays.asList(A, B, C, D, E, F);
        ArrayList<Address> members2 = new ArrayList<Address>(members1);
        members2.remove(A);
        members2.remove(F);
        members2.add(G);
        HashFunctionPartitioner keyPartitioner = new HashFunctionPartitioner(4);
        DefaultConsistentHashFactory chf = new DefaultConsistentHashFactory();
        DefaultConsistentHash ch1 = chf.create(2, 4, members1, null);
        DefaultConsistentHash ch2 = chf.updateMembers(ch1, members2, null);
        Mockito.when((Object)this.rpcManager.getAddress()).thenReturn((Object)A);
        Mockito.when((Object)this.rpcManager.invokeCommand((Address)ArgumentMatchers.any(Address.class), (ReplicableCommand)ArgumentMatchers.any(), (ResponseCollector)ArgumentMatchers.any(), (RpcOptions)ArgumentMatchers.any())).thenReturn(new CompletableFuture());
        StateProviderImpl stateProvider = new StateProviderImpl();
        TestingUtil.inject(stateProvider, this.configuration, this.rpcManager, this.commandsFactory, this.cacheNotifier, this.persistenceManager, this.dataContainer, this.transactionTable, this.stateTransferLock, this.distributionManager, this.ef, this.lpm, keyPartitioner, TransactionOriginatorChecker.LOCAL);
        stateProvider.start();
        ArrayList<ImmortalCacheEntry> cacheEntries = new ArrayList<ImmortalCacheEntry>();
        TestKey key1 = new TestKey("key1", 0, (KeyPartitioner)keyPartitioner);
        TestKey key2 = new TestKey("key2", 0, (KeyPartitioner)keyPartitioner);
        cacheEntries.add(new ImmortalCacheEntry((Object)key1, (Object)"value1"));
        cacheEntries.add(new ImmortalCacheEntry((Object)key2, (Object)"value2"));
        Mockito.when((Object)this.dataContainer.iterator()).thenAnswer(invocation -> cacheEntries.iterator());
        Mockito.when((Object)this.transactionTable.getLocalTransactions()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.transactionTable.getRemoteTransactions()).thenReturn(Collections.emptyList());
        CacheTopology simpleTopology = new CacheTopology(1, 1, (ConsistentHash)ch1, (ConsistentHash)ch1, (ConsistentHash)ch1, CacheTopology.Phase.READ_OLD_WRITE_ALL, ch1.getMembers(), persistentUUIDManager.mapAddresses(ch1.getMembers()));
        this.cacheTopology = new LocalizedCacheTopology(CacheMode.DIST_SYNC, simpleTopology, (KeyPartitioner)keyPartitioner, (Address)A, true);
        stateProvider.onTopologyUpdate((CacheTopology)this.cacheTopology, false);
        log.debug((Object)("ch1: " + String.valueOf(ch1)));
        IntSet segmentsToRequest = IntSets.from((Set)ch1.getSegmentsForOwner(members1.get(0)));
        CompletionStage transactionsStage = stateProvider.getTransactionsForSegments(members1.get(0), 1, segmentsToRequest);
        List transactions = (List)CompletionStages.join((CompletionStage)transactionsStage);
        AssertJUnit.assertEquals((int)0, (int)transactions.size());
        CompletionStage transactionsStage2 = stateProvider.getTransactionsForSegments(members1.get(0), 1, IntSets.mutableSet((int)2, (int)4));
        Exceptions.expectExecutionException(IllegalArgumentException.class, transactionsStage2.toCompletableFuture());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.stateTransferLock});
        Mockito.when((Object)this.dataContainer.iterator((IntSet)ArgumentMatchers.any())).thenReturn(cacheEntries.iterator());
        Mockito.when((Object)this.persistenceManager.publishEntries((IntSet)ArgumentMatchers.any(IntSet.class), (Predicate)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (Predicate)ArgumentMatchers.any())).thenReturn((Object)Flowable.empty());
        SegmentAwarePublisherSupplier supplier = (SegmentAwarePublisherSupplier)Mockito.mock(SegmentAwarePublisherSupplier.class);
        Mockito.when((Object)this.lpm.entryPublisher((IntSet)ArgumentMatchers.any(), (Set)ArgumentMatchers.any(), (Set)ArgumentMatchers.any(), ArgumentMatchers.eq((long)EnumUtil.bitSetOf((Enum)Flag.STATE_TRANSFER_PROGRESS)), (DeliveryGuarantee)ArgumentMatchers.any(), (Function)ArgumentMatchers.any())).thenAnswer(i -> supplier);
        List values = cacheEntries.stream().map(ice -> Notifications.value((Object)ice, (int)0)).collect(Collectors.toList());
        values.add(Notifications.segmentComplete((int)0));
        Mockito.when((Object)supplier.publisherWithSegments()).thenAnswer(i -> Flowable.fromIterable((Iterable)values));
        stateProvider.startOutboundTransfer((Address)F, 1, IntSets.immutableSet((int)0), true);
        AssertJUnit.assertTrue((boolean)stateProvider.isStateTransferInProgress());
        log.debug((Object)("ch2: " + String.valueOf(ch2)));
        simpleTopology = new CacheTopology(2, 1, (ConsistentHash)ch2, (ConsistentHash)ch2, (ConsistentHash)ch2, CacheTopology.Phase.READ_OLD_WRITE_ALL, ch2.getMembers(), persistentUUIDManager.mapAddresses(ch2.getMembers()));
        this.cacheTopology = new LocalizedCacheTopology(CacheMode.DIST_SYNC, simpleTopology, (KeyPartitioner)keyPartitioner, (Address)A, true);
        stateProvider.onTopologyUpdate((CacheTopology)this.cacheTopology, true);
        AssertJUnit.assertFalse((boolean)stateProvider.isStateTransferInProgress());
        stateProvider.startOutboundTransfer((Address)D, 1, IntSets.immutableSet((int)0), true);
        AssertJUnit.assertTrue((boolean)stateProvider.isStateTransferInProgress());
        stateProvider.stop();
        AssertJUnit.assertFalse((boolean)stateProvider.isStateTransferInProgress());
    }

    public void test2() {
        List<Address> members1 = Arrays.asList(A, B, C, D, E, F);
        ArrayList<Address> members2 = new ArrayList<Address>(members1);
        members2.remove(A);
        members2.remove(F);
        members2.add(G);
        HashFunctionPartitioner keyPartitioner = new HashFunctionPartitioner(4);
        DefaultConsistentHashFactory chf = new DefaultConsistentHashFactory();
        DefaultConsistentHash ch1 = chf.create(2, 4, members1, null);
        DefaultConsistentHash ch2 = chf.updateMembers(ch1, members2, null);
        Mockito.when((Object)this.commandsFactory.buildStateResponseCommand(Mockito.anyInt(), (Collection)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenAnswer(invocation -> new StateResponseCommand(ByteString.fromString((String)"testCache"), ((Integer)invocation.getArguments()[0]).intValue(), (Collection)invocation.getArguments()[1], true));
        Mockito.when((Object)this.rpcManager.getAddress()).thenReturn((Object)A);
        Mockito.when((Object)this.rpcManager.invokeCommand((Address)ArgumentMatchers.any(Address.class), (ReplicableCommand)ArgumentMatchers.any(), (ResponseCollector)ArgumentMatchers.any(), (RpcOptions)ArgumentMatchers.any())).thenReturn(new CompletableFuture());
        StateProviderImpl stateProvider = new StateProviderImpl();
        TestingUtil.inject(stateProvider, this.configuration, this.rpcManager, this.commandsFactory, this.cacheNotifier, this.persistenceManager, this.dataContainer, this.transactionTable, this.stateTransferLock, this.distributionManager, this.ef, this.lpm, keyPartitioner, TransactionOriginatorChecker.LOCAL);
        stateProvider.start();
        ArrayList<ImmortalCacheEntry> cacheEntries = new ArrayList<ImmortalCacheEntry>();
        TestKey key1 = new TestKey("key1", 0, (KeyPartitioner)keyPartitioner);
        TestKey key2 = new TestKey("key2", 0, (KeyPartitioner)keyPartitioner);
        TestKey key3 = new TestKey("key3", 1, (KeyPartitioner)keyPartitioner);
        TestKey key4 = new TestKey("key4", 1, (KeyPartitioner)keyPartitioner);
        cacheEntries.add(new ImmortalCacheEntry((Object)key1, (Object)"value1"));
        cacheEntries.add(new ImmortalCacheEntry((Object)key2, (Object)"value2"));
        cacheEntries.add(new ImmortalCacheEntry((Object)key3, (Object)"value3"));
        cacheEntries.add(new ImmortalCacheEntry((Object)key4, (Object)"value4"));
        Mockito.when((Object)this.dataContainer.iterator((IntSet)ArgumentMatchers.any())).thenReturn(cacheEntries.iterator());
        Mockito.when((Object)this.persistenceManager.publishEntries((IntSet)ArgumentMatchers.any(IntSet.class), (Predicate)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (Predicate)ArgumentMatchers.any())).thenReturn((Object)Flowable.empty());
        Mockito.when((Object)this.transactionTable.getLocalTransactions()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.transactionTable.getRemoteTransactions()).thenReturn(Collections.emptyList());
        CacheTopology simpleTopology = new CacheTopology(1, 1, (ConsistentHash)ch1, (ConsistentHash)ch1, (ConsistentHash)ch1, CacheTopology.Phase.READ_OLD_WRITE_ALL, ch1.getMembers(), persistentUUIDManager.mapAddresses(ch1.getMembers()));
        this.cacheTopology = new LocalizedCacheTopology(CacheMode.DIST_SYNC, simpleTopology, (KeyPartitioner)keyPartitioner, (Address)A, true);
        stateProvider.onTopologyUpdate((CacheTopology)this.cacheTopology, false);
        log.debug((Object)("ch1: " + String.valueOf(ch1)));
        IntSet segmentsToRequest = IntSets.from((Set)ch1.getSegmentsForOwner(members1.get(0)));
        CompletionStage transactionsStage = stateProvider.getTransactionsForSegments(members1.get(0), 1, segmentsToRequest);
        List transactions = (List)CompletionStages.join((CompletionStage)transactionsStage);
        AssertJUnit.assertEquals((int)0, (int)transactions.size());
        CompletionStage transactionsStage2 = stateProvider.getTransactionsForSegments(members1.get(0), 1, IntSets.mutableSet((int)2, (int)4));
        Exceptions.expectExecutionException(IllegalArgumentException.class, transactionsStage2.toCompletableFuture());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.stateTransferLock});
        SegmentAwarePublisherSupplier supplier = (SegmentAwarePublisherSupplier)Mockito.mock(SegmentAwarePublisherSupplier.class);
        Mockito.when((Object)this.lpm.entryPublisher((IntSet)ArgumentMatchers.any(), (Set)ArgumentMatchers.any(), (Set)ArgumentMatchers.any(), ArgumentMatchers.eq((long)EnumUtil.bitSetOf((Enum)Flag.STATE_TRANSFER_PROGRESS)), (DeliveryGuarantee)ArgumentMatchers.any(), (Function)ArgumentMatchers.any())).thenAnswer(i -> supplier);
        List values = cacheEntries.stream().map(ice -> Notifications.value((Object)ice, (int)0)).collect(Collectors.toList());
        values.add(Notifications.segmentComplete((int)0));
        Mockito.when((Object)supplier.publisherWithSegments()).thenAnswer(i -> Flowable.fromIterable((Iterable)values));
        stateProvider.startOutboundTransfer((Address)F, 1, IntSets.immutableSet((int)0), true);
        AssertJUnit.assertTrue((boolean)stateProvider.isStateTransferInProgress());
        log.debug((Object)("ch2: " + String.valueOf(ch2)));
        simpleTopology = new CacheTopology(2, 1, (ConsistentHash)ch2, (ConsistentHash)ch2, (ConsistentHash)ch2, CacheTopology.Phase.READ_OLD_WRITE_ALL, ch2.getMembers(), persistentUUIDManager.mapAddresses(ch2.getMembers()));
        this.cacheTopology = new LocalizedCacheTopology(CacheMode.DIST_SYNC, simpleTopology, (KeyPartitioner)keyPartitioner, (Address)A, true);
        stateProvider.onTopologyUpdate((CacheTopology)this.cacheTopology, false);
        AssertJUnit.assertFalse((boolean)stateProvider.isStateTransferInProgress());
        stateProvider.startOutboundTransfer((Address)E, 1, IntSets.immutableSet((int)0), true);
        AssertJUnit.assertTrue((boolean)stateProvider.isStateTransferInProgress());
        stateProvider.stop();
        AssertJUnit.assertFalse((boolean)stateProvider.isStateTransferInProgress());
    }

    static {
        Arrays.asList(A, B, C, D, E, F, G).forEach(address -> persistentUUIDManager.addPersistentAddressMapping((Address)address, PersistentUUID.randomUUID()));
    }
}

