/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.annotations.Test;

@CleanupAfterMethod
@Test(groups={"functional", "unstable"}, testName="statetransfer.StatefulSetRollingUpgradeTest")
public class StatefulSetRollingUpgradeTest
extends MultipleCacheManagersTest {
    private static final String CACHE_NAME = "testCache";
    private static final int NUM_ROLLING_UPGRADES = 4;
    private int numNodes;

    @Override
    public Object[] factory() {
        return new Object[]{new StatefulSetRollingUpgradeTest().setNumNodes(2), new StatefulSetRollingUpgradeTest().setNumNodes(3), new StatefulSetRollingUpgradeTest().setNumNodes(4), new StatefulSetRollingUpgradeTest().setNumNodes(5)};
    }

    private StatefulSetRollingUpgradeTest setNumNodes(int numNodes) {
        this.numNodes = numNodes;
        return this;
    }

    @Override
    protected String[] parameterNames() {
        return new String[]{"nodes"};
    }

    @Override
    protected Object[] parameterValues() {
        return new Object[]{this.numNodes};
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        Util.recursiveFileRemove((String)CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName()}));
        for (int id = 0; id < this.numNodes; ++id) {
            this.createStatefulCacheManager(id);
        }
        this.waitForClusterToForm(CACHE_NAME);
    }

    public void testStateTransferRestart() {
        for (int i = 0; i < 4; ++i) {
            for (int j = this.numNodes - 1; j > -1; --j) {
                this.manager(j).stop();
                this.cacheManagers.remove(j);
                this.waitForClusterToForm(CACHE_NAME);
                this.createStatefulCacheManager(j);
                this.waitForClusterToForm(CACHE_NAME);
            }
        }
    }

    private void createStatefulCacheManager(int id) {
        String stateDirectory = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName() + File.separator + id});
        GlobalConfigurationBuilder global = GlobalConfigurationBuilder.defaultClusteredBuilder();
        global.globalState().enable().persistentLocation(stateDirectory);
        ConfigurationBuilder config = StatefulSetRollingUpgradeTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC);
        config.clustering().partitionHandling().whenSplit(PartitionHandling.DENY_READ_WRITES).stateTransfer().timeout((long)(5 * this.numNodes), TimeUnit.SECONDS);
        EmbeddedCacheManager manager = TestCacheManagerFactory.createClusteredCacheManager(true, global, null, new TransportFlags().withFD(true));
        manager.defineConfiguration(CACHE_NAME, config.build());
        this.cacheManagers.add(id, manager);
    }
}

